#include "swu_configFactory.hpp"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_configFactory.cpp.trc.h"
#endif

namespace swu {

ItemBaseData::ItemBaseData(TiXmlElement const *root, swu::DataStore *dataStore):
   _valid(true),
   _root(root),
   _dataStore(dataStore)
{

   _name=swu::getTextFromChildOrEmpty(_root, "NAME");
   ETG_TRACE_ERR(("ItemBaseData: CTOR name=%s", _name.c_str()));
   if (_name.empty()) {
      invalidate();
      ETG_TRACE_ERR(("ItemBaseData: missing name"));
      return;
   }
   _valType=swu::getTextFromChildOrEmpty(_root, "VALTYPE");
   if (_valType != "U32" && _valType != "String" && _valType != "Vector") {
      invalidate();
      ETG_TRACE_ERR(("ItemBaseData: invalid valType:%s", _valType.c_str()));
      return;
   }
   ETG_TRACE_ERR(("ItemBaseData: valType:%s", _valType.c_str()));

}
   

bool ItemBaseData::strToVal(std::string const &str, std::string &res) {
   // trivial, just to get same calling-conventions as for othee VALTYPEs
   res=str;
   return true;
}

bool ItemBaseData::strToVal(std::string const &str, tU32 &res) {
   std::string format="%u";
   if (!str.compare(0, 2, "0x")) {
      // hex-format
      format="%x";
   }
   if (1!=sscanf(str.c_str(), format.c_str(), &res)) {
      ETG_TRACE_ERR(("ItemBaseData::strToVal(U32): could not parse format %3s: %s", format.c_str(), str.c_str()));
      invalidate();
      return false;
   }
   return true;
}

bool ItemBaseData::strToVal(std::string const &str, std::vector<tU8> &res) {
   if (!swu::hexToBin(str,res)) {
      ETG_TRACE_ERR(("ItemBaseData::strToVal(): could not parse as vector:%s", str.c_str()));
      invalidate();
      return false;
   }

   return true;
}

bool ItemBaseData::appendToVal(std::string &val, std::string appendVal) {
   val = val + appendVal;
   return true;
}

bool ItemBaseData::appendToVal(tU32 &val, tU32 appendVal) {
   return true;
}

bool ItemBaseData::appendToVal(std::vector<tU8> &val, std::vector<tU8> appendVal) {
   return true;
}




std::string ItemBaseData::readParam(TiXmlElement const *params, std::string paramName) {
   if (!params) {
      ETG_TRACE_ERR(("ItemBaseData::readParam(): missing params"));
      invalidate();
      return "";
   }
   TiXmlElement const *xmlParam=params->FirstChildElement(paramName.c_str());
   if (!xmlParam) {
      ETG_TRACE_ERR(("ItemBaseData::readParam(): missing param: %s", paramName.c_str()));
      invalidate();
      return "";
   }
   return swu::getTextFromChildOrEmpty(params, paramName.c_str());

}



}





