#ifndef FCSWUPD_CONFIG_BASE_HPP
#define FCSWUPD_CONFIG_BASE_HPP
#include <set>

#include "util/swu_types.h"
#include "util/swu_configItem.hpp"
#include "util/swu_member.hpp"

namespace swu {

class DataStore;
class ObserverRegistration;
class ConfigObserver {

protected:
   virtual ObserverRegistration &getObserverRegistration()=0;
public:

   virtual void onItemChanged(ConfigItem<tU32> *item){};
   virtual void onItemChanged(ConfigItem<std::string> *item){};
   virtual void onItemChanged(ConfigItem<std::vector<tU8> > *item){};
};


class ConfigBase:
      public MemberSimple {
public:
   ConfigBase(DataStore *dataStore=0) {
      _dataStore=dataStore;
   }

   virtual void traceState();
   static void traceActionUsr1(char const *action, std::string const &name);
   static void traceActionUsr4(char const *action, std::string const &name);
   static void traceActionUsr1(char const *action, char const *name);
   static void traceActionUsr4(char const *action, char const *name);

   template<class VALTYPE>
   void addItem(ConfigItem<VALTYPE> *item) {
      traceActionUsr4("addItem", item->_name);
      VALTYPE *pVal = 0;
      std::set<ConfigItem<VALTYPE> *> &items = getItems((VALTYPE *) 0);
      for (typename std::set<ConfigItem<VALTYPE> *>::iterator iter = items.begin(); iter != items.end(); ++iter) {
         if ((*iter)->_name == item->_name) {
            traceActionUsr1("addItem erase old", item->_name);
            items.erase(iter);
            break;
         }
      }
      items.insert(item);
      _baseItems.insert(item);
   }


   template<class VALTYPE>
   ConfigItem<VALTYPE> *getItem(VALTYPE *valType, std::string key) {
      return getItem<VALTYPE>(key);
   }

   template<class VALTYPE>
   ConfigItem<VALTYPE> *getItem(std::string key) {
      traceActionUsr4("getItem", key);
      std::set<ConfigItem<VALTYPE> *> &items = getItems((VALTYPE *) 0);
      for (typename std::set<ConfigItem<VALTYPE> *>::iterator iter = items.begin(); iter != items.end(); ++iter) {
         //         traceActionUsr4("getItem check", (*iter)->_name);
         if ((*iter)->_name == key) {
            return *iter;
         }
      }
      traceActionUsr1("getItem not found", key);
      return 0;
   }

#if 0
   template<class VALTYPE>
   void removeConfigVal(ConfigItem<VALTYPE> *item) {
      traceActionUsr4("removeConfigVal", item->_name);

      std::set<ConfigItem<VALTYPE> *> items = getItems((VALTYPE *) 0);
      typename std::set<ConfigItem<VALTYPE> *>::iterator iter = items.find(item);
      if (iter == items.end()) {
         return;
      }
      return iter->remove();
   }
#endif


   template<class VALTYPE>
   ConfigItem<VALTYPE> *getConfigValByName(std::string name) {
      traceActionUsr4("getConfigValByName", name);
      std::set<ConfigItem<VALTYPE> *> items = getItems((VALTYPE *) 0);
      for (typename std::set<ConfigItem<VALTYPE> *>::iterator iter = items.begin(); iter != items.end(); ++iter) {
         if ((*iter)->_name == name) {
            return *iter;
         }
      }
      traceActionUsr1("getConfigValByName not found", name);
      return 0;
   }

   
   template<class VALTYPE>
   void onItemChanged(ConfigItem<VALTYPE> *item) {
      SWU_TRACE_VARG(8, "onItemChanged START: item=%p ", item);

      ObserverList *observerList=getObservers(item);
      if (!observerList) {
         traceActionUsr4("onItemChanged: no observers", item->_name);
         return;
      }
      SWU_TRACE_VARG(5, "onItemChanged observerList=%p size=%u", observerList, observerList->size());
      for(ObserverList::iterator iter=observerList->begin(); iter!=observerList->end(); ++iter) {
         traceActionUsr4("onItemChanged: found observer", item->_name);
         ConfigObserver *observer=*iter;
         SWU_TRACE_VARG(5, "onItemChanged found observer %p ", observer);
         observer->onItemChanged(item);
      }
   }

   
   void setCfgStr(char const *key, char const *val);

   void setCfgU32(char const *key, tU32 val);

   void setCfgVectorU8(char const *key, char const *val);

   void traceCfgStr(char const *key);

   void traceCfgU32(char const *key);

   void traceCfgVectorU8(char const *key);


    std::set<ConfigItem<tU32> * > &getItems(tU32 *ptr) {
       return _u32Items;
    }
    std::set<ConfigItem<std::string> * > &getItems(std::string *ptr) {
       return _stringItems;
    }
    std::set<ConfigItem<std::vector<tU8> > * > &getItems(std::vector<tU8>  *ptr) {
       return _vectorItems;
    }
    std::set<ConfigItemBase *> &getItems() {
       return _baseItems;
    }
   
   void registerObserver(ConfigObserver *observer) { /* do nothing */
      SWU_TRACE_VARG(5, "registerObserver %p", observer);
      
      ConfigBase::traceActionUsr1("registerObserver", "dummy");
 };
   void removeObserver(ConfigObserver *observer) {
      SWU_TRACE_VARG(5, "removeObserver %p", observer);
      removeObserverTyped<tU32>(observer);
      removeObserverTyped<std::string>(observer);
      removeObserverTyped<std::vector<tU8> >(observer);
   }

   typedef std::set<ConfigObserver *> ObserverList;

   template<class VALTYPE>
   void removeObserverTyped(ConfigObserver *observer) {
      SWU_TRACE_VARG(8, "removeObserverTyped %p", observer);
      std::map<ConfigItem<VALTYPE > *, ObserverList *> &typedRegistrations=_registrationStorage.get((VALTYPE const *)0);
      for (typename std::map<ConfigItem<VALTYPE > *, ObserverList * >::iterator iter=typedRegistrations.begin();
           iter!=typedRegistrations.end();++iter) {
         ConfigBase::traceActionUsr1("removeObserverTyped check", iter->first->getName().c_str());
         SWU_TRACE_VARG(8, "removeObserverTyped: check item: item=%p listSize=%u observerList=%p", iter->first, iter->second->size(), iter->second);

         ObserverList::iterator iter2=iter->second->find(observer);
         if (iter2 != iter->second->end()) {
            SWU_TRACE_VARG(5, "removeObserverTyped remove!");
            iter->second->erase(observer);
         }
      }
   }

   template<class VALTYPE>
   bool observeItem(ConfigItem<VALTYPE> *item, ConfigObserver *observer) {
      traceActionUsr1("observeItemTyped(item) start", item->_name);
      SWU_TRACE_VARG(8, "observeItemTyped(item) start: item=%p observer=%p", item, observer);

      ObserverList *observers=getObservers(item);
      SWU_TRACE_VARG(8, "observeItemTyped(item) start: observers=%p", observers);
      // get the list of observers
      if (!observers) {
         SWU_TRACE_VARG(8, "observeItem: create list for item %s", item->_name.c_str());
         ObserverList *newList=new ObserverList;
         SWU_TRACE_VARG(8, "observeItem: create list for item %s observerList=%p", item->_name.c_str(), newList);
         newList->insert(observer);
         _registrationStorage.get((VALTYPE const *)0)[item]=newList;
         return true;
      }
      // check, if the observer is already registered
      ObserverList::iterator iter=observers->find(observer);
      if (iter != observers->end()) {
         traceActionUsr1("observeItem: already registered item", item->_name);
         return true;
      }
      traceActionUsr1("observeItem: add observer to item", item->_name);
      observers->insert(observer);
      return true;
      
   }
   template<class VALTYPE>
      bool observeItem(std::string name, ConfigObserver *observer) {
      traceActionUsr1("observeItem(name) start", name);
      ConfigItem<VALTYPE> *item=ConfigBase::getConfigValByName<VALTYPE>(name);
      if (!item) {
         traceActionUsr1("observeItem(name) item does not exist", name);
         return false;
      }
      return observeItem(item, observer);
   }

protected:
   std::set<ConfigItem<tU32> * > _u32Items;
   std::set<ConfigItem<std::string> * > _stringItems;
   std::set<ConfigItem< std::vector<tU8> > * > _vectorItems;
   std::set<ConfigItemBase * > _baseItems;

   class registrationStorage {
   public:
      std::map<ConfigItem<tU32 > *, ObserverList *> &get(tU32 const *) {
         return _registrationStorageU32;
      }
      std::map<ConfigItem<std::string > *, ObserverList *> &get(std::string const *) {
         return _registrationStorageString;
      }
      std::map<ConfigItem<std::vector<tU8> > *, ObserverList *> &get(std::vector<tU8> const *) {
         return _registrationStorageVector;
      }

   private:
      std::map<ConfigItem<tU32 > *, ObserverList *> _registrationStorageU32;
      std::map<ConfigItem<std::string > *, ObserverList *> _registrationStorageString;
      std::map<ConfigItem<std::vector<tU8> > *, ObserverList *> _registrationStorageVector;
      
   } _registrationStorage;
   

   // get list of observers for a config-item
   template<class VALTYPE>
      ObserverList *getObservers(ConfigItem<VALTYPE > *configItem) {
      SWU_TRACE_VARG(8, "getObservers start: item=%p", configItem);

      std::map<ConfigItem<VALTYPE > *, ObserverList *> typedRegistrations=_registrationStorage.get((VALTYPE const *)0);
      typename std::map<ConfigItem<VALTYPE > *, ObserverList *>::iterator iter=typedRegistrations.find(configItem);
      if (iter == typedRegistrations.end()) {
         SWU_TRACE_VARG(8, "getObservers end: NOT FOUND");
         return 0;
      }
      ObserverList *observerList =iter->second;
      SWU_TRACE_VARG(8, "getObservers end: item=%p observerList=%p", configItem, observerList);
      return observerList;
   }
   

   DataStore *_dataStore;
};



class ObserverRegistration {
 public:
   ObserverRegistration(ConfigObserver *observer, ConfigBase *cfg):
      _observer(observer)
      , _cfg(cfg)
   {
      
   }
   ~ObserverRegistration() {
      if (_cfg && _observer) {
         _cfg->removeObserver(_observer);
      }
   }
 private:
   ConfigObserver *_observer;
   ConfigBase *_cfg;
   
};

}

#endif
