#include "util/swu_configBase.hpp"
#include <iostream>
#include <fstream>
#include "util/swu_registry.h"
#include "util/swu_dataStore.hpp"
#include "util/swu_filesystem.h"
#include "util/swu_environment.hpp"
#include "util/swu_kds.h"
#include "util/swu_dataStore.hpp"


#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_configBase.cpp.trc.h"
#endif

using namespace std;

namespace swu {


void ConfigBase::traceActionUsr1(char const  *action, std::string const &name) {
   ETG_TRACE_USR1(("Config::%30s (%s)" , action, name.c_str()));
}
void ConfigBase::traceActionUsr4(char const  *action, std::string const &name) {
   ETG_TRACE_USR1(("Config::%30s (%s)" , action, name.c_str()));
}
void ConfigBase::traceActionUsr1(char const *action,  char const *name) {
   ETG_TRACE_USR1(("Config::%30s (%s)" , action, name));
}
void ConfigBase::traceActionUsr4(char const *action, char const *name) {
   ETG_TRACE_USR1(("Config::%30s (%s)" , action, name));
}





void ConfigBase::traceState() {
   ETG_TRACE_COMP(("%s::traceState START\n", getName()));
ETG_TRACE_COMP(("  U32-Items:"));
{
   set<ConfigItem<tU32> *> &items=getItems((tU32 *)0);
      for(typename set<ConfigItem<tU32> *>::iterator iter=items.begin();
          iter!=items.end();
          ++iter)
      {
         ConfigItem<tU32> *item=*iter;
         tU32 val;
         bool res=item->get(val);
         ETG_TRACE_COMP(("    ITEM: key=%50s valid=%u val=%u", item->_name.c_str(), res, val));
      }
   }


   ETG_TRACE_COMP(("String-Items:"));
   {
      set<ConfigItem<string> *> &items=getItems((string *)0);
      for(typename set<ConfigItem<string> *>::iterator iter=items.begin();
          iter!=items.end();
          ++iter)
      {
         ConfigItem<string> *item=*iter;
         string val;
         bool res=item->get(val);
         ETG_TRACE_COMP(("    ITEM: key=%50s valid=%u val=%s", item->_name.c_str(), res, val.c_str()));
      }
   }

   ETG_TRACE_COMP(("vector<tU8>-Items:"));
   {
      set<ConfigItem<vector<tU8> > *> &items=getItems((vector<tU8> *)0);
          for(typename set<ConfigItem<vector<tU8> > *>::iterator iter=items.begin();
              iter!=items.end();
              ++iter)
          {
             ConfigItem<vector<tU8> > *item=*iter;
             vector<tU8> val;
             bool res=item->get(val);
             ETG_TRACE_COMP(("ITEM: key=%50s valid=%u val=%02x", item->_name.c_str(), res,
                              ETG_LIST_LEN(val.size()), ETG_LIST_PTR_T8(&val[0])));
          }
   }

ETG_TRACE_COMP(("%s::traceState END\n", getName()));

}

    void ConfigBase::setCfgStr(char const *key, char const *val) {
       ConfigItem<string> *item=getItem<string>(key);
       if (!item) {
          ETG_TRACE_ERR(("setCfgStr:Item not found (key=%s)", key));
          return;
       }
       bool res=item->set(val);
       ETG_TRACE_COMP(("Config::setCfgStr:key=%50s res=%u val=%s",
                       key, res, val));
    }


    void ConfigBase::traceCfgStr(char const *key) {
       std::string val;
       ConfigItem<string> *item=getItem<string>(key);
       if (!item) {
          ETG_TRACE_ERR(("Config::traceCfgStr:Item not found (key=%s)", key));
          return;
       }
       bool res=item->get(val);
       ETG_TRACE_FATAL(("Config::traceCfgStr:key=%50s res=%u val=%s",
                        key, res, val.c_str()));
    }

    void ConfigBase::setCfgU32(char const *key, tU32 val) {
       ConfigItem<tU32> *item=getItem<tU32>(key);
       if (!item) {
          ETG_TRACE_ERR(("Config::setCfgU32:Item not found (key=%s)", key));
          return;
       }
       bool res=item->set(val);
       ETG_TRACE_COMP(("Config::setCfgU32: key=%50s res=%u val=%u ", key, res, val));
    }


    void ConfigBase::traceCfgU32(char const *key) {
       tU32 val;
       ConfigItem<tU32> *item=getItem<tU32>(key);
       if (!item) {
          ETG_TRACE_ERR(("Config::traceCfgU32:Item not found (key=%s)", key));
          return;
       }
       bool res=item->get(val);
       ETG_TRACE_FATAL(("Config::traceCfgU32:key=%50s res=%u val=%u",
                        key, res, val));
    }

    void ConfigBase::setCfgVectorU8(char const *key, char const *val) {
       ConfigItem<vector<tU8> > *item=getItem<vector<tU8> >(key);
       if (!item) {
          ETG_TRACE_ERR(("setCfgVectorU8:Item not found (key=%s)", key));
          return;
       }
       tU32 u32StrLen=static_cast<tU32> (strlen(val) );
       if (!u32StrLen || (u32StrLen%2)) {
          ETG_TRACE_ERR(("setCfgVectorU8:invalid strlen (%u)", u32StrLen));
          return;

       }
       std::vector< unsigned char > binVal;
       swu::hexToBin(val, strlen(val), binVal);
       bool res=item->set(binVal);
       ETG_TRACE_COMP(("Config::setCfgU32: key=%50s res=%u val=%02x ", key, res, 
                       ETG_LIST_LEN(binVal.size()), ETG_LIST_PTR_T8(&binVal[0])));
    }



    void ConfigBase::traceCfgVectorU8(char const *key) {
       vector<tU8> val;
       ConfigItem<vector<tU8> > *item=getItem<vector<tU8> >(key);
       if (!item) {
          ETG_TRACE_ERR(("Config::traceCfgVectorU8:Item not found (key=%s)", key));
          return;
       }
       bool res=item->get(val);
       ETG_TRACE_COMP(("Config::setCfgU32: key=%50s res=%u val=%02x ", key, res, 
                       ETG_LIST_LEN(val.size()), ETG_LIST_PTR_T8(&val[0])));
    }


}


