#ifndef SWU_CERTIFICATE_H
#define SWU_CERTIFICATE_H

#include <string>
#include <openssl/x509.h>

#include "util/swu_singleton.hpp"

namespace swu {

class CodeCert : public Singleton<CodeCert> {
public:
   /** @brief Validate a certificate with another one.
    *
    *  Both certificates have to be valid X509 certificates in PEM format.
    *
    *  @param caCert  A string containing the certificate against which the other is validated.
    *  @param cert    A string containing the certificate to validate.
    *  @return        True if cert is validated by caCert, else false.
    */
   bool validateCertificate(const std::string& caCert, const std::string& cert) const;
   bool validateCertificate(X509* caCert, X509* codeCert) const;

   /** @brief Extract the public key from a given certificate.
    *
    *  The certificate has to be a valid X509 certificate in PEM format.
    *
    *  @param certificate  A string with the certificate which is the source of the public key.
    *  @param key          This will hold the extracted public key on success.
    *  @return             True if a public key could be extracted, false otherwise.
    */
   bool extractPublicKeyFromCertificate(const std::string& certificate, std::string& key) const;

   bool checkSignature(const std::string &, const std::string&, const std::string& key) const;
};


class TestSignature : public Singleton<TestSignature> {
public:
   void vInit() const;

   void testCheckSignature(const char *messageFile, const char *signatureFile, const char *keyFile) const;
   void testCheckSignatureWithSystemkey(const char *messageFile, const char *signatureFile) const;
};

}
#endif
