
#ifndef SWU_BOOTCHAINACCESS_HPP_
#define SWU_BOOTCHAINACCESS_HPP_

#include "util/swu_types.h"
//#include "util/swu_imxBootChain.h"
#include "util/swu_rcarBootChain.h"

#include "util/swu_trace.h"


namespace swu {

template <class COMP>
class BootChainAccess {

public:  
   static const bool activateRecoveryMode() {
      return COMP::instance()->activateRecoveryMode();
   }
   
   static const bool activateApplicationMode() {
      return COMP::instance()->activateApplicationMode();
   }
   
   static const bool switchBootChainOne() {
      return COMP::instance()->switchBootChainOne();
   }
   
   static const bool switchBootChainTwo() {
      return COMP::instance()->switchBootChainTwo();
   }

   static const bool switchBootSectors() {
      return COMP::instance()->switchBootSectors();
   }
   
   static const bool usedBootChain(tU32 &activeChain) {
      return COMP::instance()->usedBootChain(activeChain);
   }
   
   static const bool isRecoveryMagicSet(bool &isSet) {
      return COMP::instance()->isRecoveryMagicSet(isSet);
   }
   
   static bool readMagic(const tU32 flashAddr, tU32 &val){
      return COMP::instance()->readMagic(flashAddr, val);
   }

   static bool writeMagic(const tU32 flashAddr, tU32 val){
      return COMP::instance()->writeMagic(flashAddr, val);
   }

   static bool writeMagicToActiveSector(const tU32 flashAddr, tU32 val){
      return COMP::instance()->writeMagicToActiveSector(flashAddr, val);
   }

   static void dumpBootChainConfig() {
      COMP::instance()->dumpBootChainConfig();
   }

};


}

#endif
