#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#include "util/swu_types.h"
#include "util/swu_constants.hpp"
#include "util/swu_util.hpp"
#include "util/swu_bootChain.h"
#include "util/swu_trace.h"
#include "util/swu_bootChainAccess.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_bootChain.cpp.trc.h"
#endif 

namespace swu {

MagicArea::MagicArea():
   _magics(0)
{}

MagicArea::~MagicArea() {
   release();
}

char const *MagicArea::get() {
   if (!_magics) {
      _magics=new char[Constants::Mmc::MTD_MAGIC_BUFFER_SIZE];
      int handle;
      if(-1 == (handle = open(Constants::Mmc::MTD0_DEVICE_NAME, O_RDONLY))) {  // try to open file
         if(-1 == (handle = open(Constants::Mmc::MTD0_BLOCK_DEVICE_NAME, O_RDONLY)))
         {
            ETG_TRACE_ERR(("usedBootChain: Can't open %s", Constants::Mmc::MTD0_DEVICE_NAME));   
            release();
            return 0;
         }
      }
      char mtdBuf1[Constants::Mmc::MTD_MAGIC_BUFFER_SIZE];
      char mtdBuf2[Constants::Mmc::MTD_MAGIC_BUFFER_SIZE];
      if(Constants::Mmc::MTD_MAGIC_CHAIN1_OFFSET != lseek(handle, Constants::Mmc::MTD_MAGIC_CHAIN1_OFFSET, SEEK_SET))
      {
         ETG_TRACE_ERR(("usedBootChain: Can't lseek %s", Constants::Mmc::MTD0_DEVICE_NAME));  
         release();
         close(handle);
         return 0;
      }
      if(Constants::Mmc::MTD_MAGIC_BUFFER_SIZE !=
         static_cast<uint32_t> (read(handle, mtdBuf1, Constants::Mmc::MTD_MAGIC_BUFFER_SIZE)))
      {
         ETG_TRACE_ERR(("usedBootChain: Can't read %s", Constants::Mmc::MTD0_DEVICE_NAME));   
         release();
         close(handle);
         return 0;
      }
      if(Constants::Mmc::MTD_MAGIC_CHAIN2_OFFSET != lseek(handle, Constants::Mmc::MTD_MAGIC_CHAIN2_OFFSET, SEEK_SET))
      {
         ETG_TRACE_ERR(("usedBootChain: Can't lseek %s", Constants::Mmc::MTD0_DEVICE_NAME));  
         release();
         close(handle);
         return 0;
      }
      if(Constants::Mmc::MTD_MAGIC_BUFFER_SIZE !=
         static_cast<uint32_t>(read(handle, mtdBuf2, Constants::Mmc::MTD_MAGIC_BUFFER_SIZE)))
      {
         ETG_TRACE_ERR(("usedBootChain: Can't read %s", Constants::Mmc::MTD0_DEVICE_NAME));   
         release();
         close(handle);
         return 0;
      }
      close(handle);
      bool magicOneValid = (Constants::Mmc::VALID_MAGIC_VALUE == extractUint(mtdBuf1));
      bool  magicTwoValid = (Constants::Mmc::VALID_MAGIC_VALUE == extractUint(mtdBuf2));
      unsigned int count1 = 0, count2 = 0;
      char * useMagicBlock = mtdBuf1;
      if(true == magicOneValid)
      {
         ETG_TRACE_USR3(("usedBootChain: Magic1 is valid "));
         count1 = extractUint(mtdBuf1 + 0x10);
      }
      if(true == magicTwoValid)
      {
         ETG_TRACE_USR3(("usedBootChain: Magic2 is valid"));   
         count2 = extractUint(mtdBuf2 + 0x10);
      }
      
      if(false == magicOneValid)
      {
         if(true == magicTwoValid)
         {
            useMagicBlock = mtdBuf2;
         }
         else
         {
            ETG_TRACE_ERR(("usedBootChain: Both magics are invalid"));  
            release();
            return 0;
         }
      }
      if(count2 > count1) {
         useMagicBlock = mtdBuf2;
      }

      ETG_TRACE_USR3(("usedBootChain: Use NOR block 0x%x",
                      (useMagicBlock == mtdBuf1) ? Constants::Mmc::MTD_MAGIC_CHAIN1_OFFSET : Constants::Mmc::MTD_MAGIC_CHAIN2_OFFSET));
      memcpy(_magics, useMagicBlock, Constants::Mmc::MTD_MAGIC_BUFFER_SIZE);
      
   }
   return _magics;
}

void MagicArea::release() {
   if (_magics) {
      delete[] _magics;
      _magics=0;
   }
}

bool BootChain::usedBootChain(int &chain)
{
#ifndef VARIANT_S_FTR_ENABLE_G4G
    MagicArea magics;
    char const *curMagics=magics.get();
    if (!curMagics) {
        return false;
    }
    if(Constants::Mmc::USE_SECOND_BOOT_CHAIN == extractUint(curMagics + 0x40))
    {
        chain = 2;
        ETG_TRACE_USR3(("usedBootChain: Active second bootchain"));
    }
    else
    {
        chain = 1;
        ETG_TRACE_USR3(("usedBootChain: Active first bootchain"));
    }
#else
    tU32 activeChain;
    BootChainAccess<rcarBootChain>::usedBootChain(activeChain);
    chain = activeChain;
#endif
   return true;
}

bool BootChain::isRecoveryMagicSet(bool &isSet) {
#ifndef VARIANT_S_FTR_ENABLE_G4G
    MagicArea magics;
    char const *curMagics=magics.get();
    if (!curMagics) {
        return false;
    }
    if(Constants::Mmc::MTD_RECOVERY_MAGIC_ACTIVE == extractUint(curMagics + Constants::Mmc::MTD_RECOVERY_MAGIC_OFFSET))
    {
        isSet=true;
        ETG_TRACE_USR3(("isRecoveryMagicSet: TRUE"));
    }
    else
    {
        isSet=false;
        ETG_TRACE_USR3(("isRecoveryMagicSet: FALSE"));
    }
#else
    BootChainAccess<rcarBootChain>::isRecoveryMagicSet(isSet);  
#endif
   return true;

   
}

}
