#ifndef SWU_BOARD_ID_H
#define SWU_BOARD_ID_H
#include "util/swu_types.h"
#include "util/swu_trace.h"
namespace swu {
#define FAC_FILE_TO_READ_BOARDID                          "/tmp/BoardID"
#define FAC_BOARID_COMMAND_HYPERFLASH                     "./fac_out.out -GetBoardID -of " FAC_FILE_TO_READ_BOARDID


class BoardId {
public:
   BoardId():
      _board_id_set(false),
      _autosar_board_id_set(false),
      _board_id(0),
      _autosar_board_id(0)
   {}
     typedef enum {
    enBoardIdType_LINUX,
    enBoardIdType_AUTOSAR
   } tenBoardIdType;
   unsigned int get(tenBoardIdType boardType=BoardId::enBoardIdType_LINUX);
private:
   static const char* MEMFILEPATH;
   static const uint32_t OCOTP_CTRL=(0x21BC000);
   static const uint32_t OFFSET_OCOTP_GP1=(0x21BC660);
   static const uint32_t OFFSET_OCOTP_GP2=(0x21BC670);
   static const uint32_t RANGE_OCOTP=0x800;
   bool _board_id_set;
   unsigned int _board_id;
   unsigned int _autosar_board_id;
   bool _autosar_board_id_set;
   void getBoardIDFromHyperFlash(unsigned int *combinedBoardId);

};


}
#endif
