#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include "util/swu_types.h"
#include "util/swu_constants.hpp"
#include "util/swu_boardId.h"
#include "util/swu_trace.h"
#include "swu_execCommand.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_boardId.cpp.trc.h"
#endif 

namespace swu {

const char *BoardId::MEMFILEPATH ="/dev/mem";

unsigned int BoardId::get(tenBoardIdType boardType) {
   ETG_TRACE_USR1(("SystemData::getBoradID() was called"));

#ifndef VARIANT_S_FTR_ENABLE_G4G
   if (!_board_id_set) {
      int fd;
      volatile unsigned int *map; /* mmapped array of int's */
      unsigned int board_id_low, checksum, tmp;

      /* Open "/dev/mem" for reading */
      if ((fd = open(MEMFILEPATH, O_RDONLY | O_SYNC)) == -1) {
         ETG_TRACE_ERR(("SystemData::getBoradID(): could not open for loading %s", MEMFILEPATH));
         return 0;
      }
      map = (unsigned int *) mmap(0, RANGE_OCOTP, PROT_READ, MAP_SHARED, fd, OCOTP_CTRL);
      if (map == MAP_FAILED) {
         close(fd);
         ETG_TRACE_ERR(("SystemData::getBoradID(): Error mmapping the file %s", MEMFILEPATH));
         return 0;
      }
      _board_id = *(map + (OFFSET_OCOTP_GP2 - OCOTP_CTRL) / sizeof(unsigned int));
      board_id_low = *(map + (OFFSET_OCOTP_GP1 - OCOTP_CTRL) / sizeof(unsigned int));
      /* free the mmapped memory     */
      if (munmap((void *) map, RANGE_OCOTP)) {
         ETG_TRACE_ERR(("SystemData::getBoradID(): Error unmmapping the file %s", MEMFILEPATH));
      }
      close(fd); /* close the "/dev/mem"    */

      if (_board_id & 0xffff0000l) {
         _board_id >>= 16;
      }
      else {
         _board_id &= 0xffff;
         if (!_board_id) {
            if (board_id_low & 0xffff0000l) {
               _board_id = board_id_low >> 16;
            }
            else
               _board_id = board_id_low & 0xffff;
         }
      }
      checksum = (~(_board_id >> 12)) & 0x0f;     // bits 12-15 are checksum
      tmp = _board_id &= 0x0fff;               // 12 LS bits is BoardID
      // checksum shall be one's complement of amount of set bits in BoardID
      while (tmp) {         // Not set BoardID ( == 0) fails on this check too
         if (tmp & 1)
            checksum--;
         tmp >>= 1;
      }
      if (checksum) {
         ETG_TRACE_ERR(("SystemData::getBoradID(): Error in checksum"));
         return 0;
      }
      _board_id_set = true;
      ETG_TRACE_USR1(("SystemData::getBoradID() read board id %u", _board_id));
   }
   return _board_id;
#else
      // For details Refer https://inside-docupedia.bosch.com/confluence/display/GG/Renesas+BoardID
      // The below code is commented out since the implementation from ESO is pending.
      // It should be uncommented once the implementation is available
    //   unsigned int combinedBoardId = 0;

    //   if(boardType == BoardId::enBoardIdType_LINUX)
    //   {
    //      if (!_board_id_set) {
    //         getBoardIDFromHyperFlash(&combinedBoardId);
    //         if(combinedBoardId > 0)
    //         {
    //            _board_id = (combinedBoardId>>4) & 0x000FFFFF;
    //            _board_id_set = true;
    //         }
    //      }
    //      return _board_id;
    //   }
    //   else if(boardType == BoardId::enBoardIdType_AUTOSAR)
    //   {
    //      if(!_autosar_board_id_set)
    //      {
    //         getBoardIDFromHyperFlash(&combinedBoardId);
    //         if(combinedBoardId > 0)
    //         {
    //            _autosar_board_id = (((combinedBoardId&0x00FFFF00) | ((combinedBoardId&0x0F)<<4)) >>4) & 0x000FFFFF;
    //            _autosar_board_id_set = true;
    //         }
    //      }
    //      return _autosar_board_id;
    //   }
    //   else
    //   {
    //      return 0;
    //   }
    return _board_id;
#endif

}

void BoardId::getBoardIDFromHyperFlash(unsigned int *combinedBoardId) {

    std::string sysCmd = "";
    std::string OutputFile = FAC_FILE_TO_READ_BOARDID;
    int fd = -1;
    int retcode =-1;

    sysCmd=FAC_BOARID_COMMAND_HYPERFLASH;

    fprintf(stderr, "ReadBoardId:sysCmd:%s\n", sysCmd.c_str());
    execCommand(sysCmd.c_str());

    fd = open(OutputFile.c_str(),O_RDONLY);
    if(fd >= 0)
    {
        retcode =static_cast<int> (read(fd, combinedBoardId, 4));
        fprintf(stderr, "readFromFac:retcode:%d\n", retcode);
        close(fd);
    }
    execCommand("rm -rf /tmp/BoardID");
}

}
