#ifndef SWU_BOOTCHAINMGR_H_
#define SWU_BOOTCHAINMGR_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace swu {

/**
 * Manager class for boot chains.
 * @todo add legacy functionality to this class in order to provide an integrate approach to modify boot chain control data.
 */
class RawFlashBootChainMgr
{
public:

    virtual ~RawFlashBootChainMgr(){}
    /**
     * Activates the recovery mode for the active boot chain.
     * @return true for success, else false
     */
    virtual const bool activateRecoveryMode() =0;


    /**
     * Activates the application mode for the active boot chain.
     * @return true for success, else false
     */
    virtual const bool activateApplicationMode() =0;

    /**
     * Switch the active boot chain to One.
     * @return true for success, else false
     */
    virtual const bool switchBootChainOne()=0;

    /**
     * Switch the active boot chain to Two.
     * @return true for success, else false
     */
    virtual const bool switchBootChainTwo()=0;

    //@todo: activateBootChain(param BC1, BC2);
    //@todo: BC1 or BC2 activeBootchain();

    virtual bool bWriteMagicToRawFlash (unsigned int u32FlashMagicOffset, unsigned int u32Value) = 0;

    virtual bool bReadMagicFromRawFlash (const unsigned int inFlashAddress, unsigned int& outValue) = 0;

    virtual bool bWriteMagicBootChain (const unsigned int inFlashAddress, const unsigned int inValue) = 0;

    virtual bool bReadFlagFromRawFlash (off_t u32FlashAdress, tPU32 pu32Value) =0;

    virtual bool usedBootChain(int &chain) =0;

    virtual bool usedBootChain() =0;

    virtual bool isRecoveryMagicSet(bool &isSet) =0;

    virtual bool isRecoveryMagicSet()=0;

};



}

#endif
