/*******************************************************************************************
* FILE:			 TFTPClient.cpp
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION:  A TFTP client that will request a connections from the server and transefet files.
*					 Here we are using the sendto and recvfrom functions so the server and client
*				    can exchange data.
*
* AUTHOR:		 Aditya Kumar Jha
*
* COPYRIGHT:	 (c) 2013 – 2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
*
********************************************************************************************/

#ifndef _DL_TFTP_CLIENT_H
#define _DL_TFTP_CLIENT_H



#include <string>
#include <arpa/inet.h>

#define tU32 unsigned int
#define tU8 unsigned char
#define tInt int
#define tUInt unsigned int
#define tString char *
#define tChar char
#define tCString char const *
//#include "ai_osal_linux/components/system/system_types.h"

/* for pipe */
#define READ 0
#define WRITE 1

//defines for tftp requests
#define TFTP_RRQ 			0x01
#define TFTP_WRQ 			0x02
#define TFTP_DATA 			0x03
#define TFTP_ACK 			0x04
#define TFTP_ERR 			0x05
#define TFTP_OACK 			0x06

#define TFTP_ERROR 			-1
#define TFTP_OK 			0

#define TFTP_TIME_OUT 		2000
#define TFTP_MAX_PKT_RETRIES 	12
#define TFTP_MAX_FILE_RETRIES 	4
#define TFTP_MAX_PACKETSIZE 65464
#define TFTP_MAX_TX_PKT_SIZE 200
#define TFTP_HEADER_SIZE 4
#define TFTP_LOG_FILE "/tmp/tftp.log"

using namespace std;





class TftpClient
{
public:


   TftpClient(string serverIpAddress, tU32 maxPktSize=_defaultMaxPktSize);
   ~TftpClient();
   bool open();
   void close();
   bool getFile(string rcvFileName);
   bool sendErrorMessage(string Message);

private:
   static const tInt _tftpPort=69;
   //   static const tU32 _defaultMaxPktSize=8192+4;
   static const tU32 _defaultMaxPktSize=TFTP_MAX_PACKETSIZE;
   //   static const tU32 _defaultMaxPktSize=512;
   TftpClient ( const TftpClient & ); //Coverity fix for 48212
   TftpClient & operator = ( const TftpClient & ); //Coverity fix for 47743


   struct sockaddr_in _server;
   tInt _sock;
   tInt _tid;
   tUInt _maxPktSize;
   string _serverIpAddress;
   tU32 _u32BlockNumber;
   string _rcvFileName;
   tU8 *_packetBuf;
   tChar _txBuf[TFTP_MAX_TX_PKT_SIZE];
   FILE  *_fpLog;
   bool _bOpen;
   string _logFile;

   bool openConnection();
   bool requestFile();
   bool receiveFile();
   tInt iRxPacket();
   tInt iSendAck();
   tInt iSendError(tU32 u32ErrCode, tCString pchErrMsg);


};

#endif /* _DL_TFTP_CLIENT_H */
