/************************************************************************
* File: teseo_ResponseReceiver.h
* SW-Component: 
*
* Description:
*	Receives teseo responses from linux GNSS proxy driver for 
*	teseo download queries. 
* Author:
*   Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 14.10.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 27.08.2013 - Implemented CMG3G-5318 optimized logging using update.log - Apoorva K R (RBEI/ECA1)
* 6/4/2015 - Implemented CMG3G-6728 IS2030_Teseo update only if CRC changed@Integration Tooling - Apoorva K.R (RBEI/ECA1)
 * 1/1/2016 - Implemented CMG3G-9339 Teseo-3 support in SWUpdate - Anusha Ghali (RBEI/ECA1)
*---------------------------------------------------------------------------------------------------
* 1/2/2016          | AGL5KOR (RBEI)    |     CMG3G-9450 - teseo update ctrl app to be modified to write and read CRC
* 				    | Anusha Ghali	    | 
*---------------------------------------------------------------------------------------------------
***********************************************************************/
#ifndef _TESEO_RESPONSE_RECEIVER_H_
#define _TESEO_RESPONSE_RECEIVER_H_

#include <pthread.h>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "teseo_SWBinaryHandler.h"
#include "UpdateLog.h"
#include <string>
#include <cstdio>
#include <unistd.h>
#include <time.h>
#include <getopt.h>
#include <fcntl.h>

using namespace ::ai_sw_update::common;

class teseo_SWUpdater {

public:
	teseo_SWUpdater();
	~teseo_SWUpdater();
	
	tBool bInitSWUpdater(std::string &strFlasherPath,
					    std::string &strTeseoFWBinPath);
	tU8 u8CompareCRC(std::string &strTeseoFWBinPath);
	tU8 u8CalcCRCForBin(tU8& u8CRCCalcExitCode);
	tU8 u8CalcCRCForFwUpdate (tU8& u8CRCCalcExitCode, \
		bool bFlasherCrc , \
		const std::string& strTeseoFWBinPath = "", \
		const std::string& strPathToFile = "");
	tU8 u8GetCRCFromGNSS (tU8& u8CRCFromGNSSExitCode, \
		const std::string& strPathToFile = "");
		
private:
    // Private methods
	tVoid vProcessEvent();
	tVoid vTeseoSWUpdate();
	tBool vTeseoSWUpdateSequence();
	tBool bSendTeseoBootLoader();
	tBool bSendFWBinSizeAndCRC();
	tBool bSendBootloaderSizeAndCRC();
	tBool bSendTeseoFirmware();
	tBool bWriteTeseoSWBytes();
	tBool bNotifyTeseoChipTypeToGNSS();
	tBool bPostStatusEvent(tU8 u8UpdtState, tU8 u8Ev) const;
	tBool bPostEvent() const;
	tVoid vUpdateStatus(tU8 u8UpdtState, tU8 u8Ev) const;
	tBool vCloseFile();
	tBool bWriteCRCToFile (const std::string& strPathToFile, tU32& u32Crc32);
	void teseo_print2stdout(const char *Format, ...);
	
    static tVoid* vTeseoSWUpdaterThreadCallback(tVoid* arg)
    {
		//Callback func for Updater thread creation
        reinterpret_cast<teseo_SWUpdater *>(arg)->vTeseoSWUpdaterThreadFunction();
        return NULL;
    }

	tVoid vTeseoSWUpdaterThreadFunction();	
	
	teseo_SWBinaryHandler m_BinaryHandler;
	std::string m_strFlasherBinPath;
	std::string m_strTeseoFWBinPath;
	tU32 m_u32FlashedFwCRC;
	tU32 m_u32NewFwCRC;
	OSAL_tIODescriptor m_gnssFd;
};

#endif //_TESEO_RESPONSE_RECEIVER_H_
