/************************************************************************
* File: teseo_SWUpdateMgr.h
* SW-Component: 
*
* Description:
*	Handles events from teseo DL client and teseo response receiver 
* Author:
*   Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 14.10.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 27.08.2013 - Implemented CMG3G-5318 optimized logging using update.log - Apoorva K R (RBEI/ECA1)
* 6/4/2015 - Implemented CMG3G-6728 IS2030_Teseo update only if CRC changed@Integration Tooling - Apoorva K.R (RBEI/ECA1)
*---------------------------------------------------------------------------------------------------
* 1/2/2016          | AGL5KOR (RBEI)    |     CMG3G-9450 - teseo update ctrl app to be modified to write and read CRC
* 				    | Anusha Ghali	    | 
*---------------------------------------------------------------------------------------------------
***********************************************************************/
#ifndef _TESEO_SW_UPDATE_MANAGER_H_
#define _TESEO_SW_UPDATE_MANAGER_H_

#include <pthread.h>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "teseo_Global.h"
#include "teseo_SWUpdater.h"
#include "UpdateLog.h"

using namespace ::ai_sw_update::common;

class teseo_SWUpdateMgr {

public:
	teseo_SWUpdateMgr();
	virtual ~teseo_SWUpdateMgr();
	
	tBool bInitUpdateMgr(std::string& strFlasherPath,
					  std::string& strTeseoFWBinPath);
					  
	tU8 u8InitUpdateMgrForCRC(std::string& strTeseoFWBinPath, \
		const std::string& strPathToFile, bool bCRCFromGNSS,\
			bool bCRCFromUpdtCtl, bool bFlasherCrc);
	
	static OSAL_tEventHandle  m_evHandleMgr;
	static OSAL_tEventHandle  m_evHandleSWUpdater;
	
	static tU8 m_evMgrToSWUpdater;
	static tU8 m_evSWUpdaterToMgr;
	static tU8 m_evSWUpdateClientToMgr;
	
	static tU8 m_SWUpdateState;
	static tU8 m_SWUpdateStatus;

	T_fCallback m_fptrClientCb;
	pthread_mutex_t m_swUpdateMutex;
	
protected:
	tVoid vProcessClientEvent();
	tVoid vProcessSWUpdaterEvent();
	tBool bPostEventtoSWUpdater() const;
	teseo_SWUpdater m_teseoSWUpdater;
	
private:
    // Private methods
    static tVoid* vUpdateMgrThreadCallback(tVoid* arg)
    {
        reinterpret_cast<teseo_SWUpdateMgr *>(arg)->vSWUpdateMgrThreadFunction();
        return NULL;
    }
	tVoid vSWUpdateMgrThreadFunction();
	std::string m_strFlasherBinPath;
	std::string m_strTeseoFWBinPath;
};

#endif //_TESEO_SW_UPDATE_MANAGER_H_
