/************************************************************************
* File: teseo_Global.h
* SW-Component:
*
* Description:
*	All teseo sw updated related common declarations and definitions
*
* Author:
*   Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 14.10.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 6/4/2015 - Implemented CMG3G-6728 IS2030_Teseo update only if CRC changed@Integration Tooling - Apoorva K.R (RBEI/ECA1)
* 1/1/2016 - Implemented CMG3G-9339 Teseo-3 support in SWUpdate - Anusha Ghali (RBEI/ECA1)
* 3/1/2016 - Implemented fix for CMG3GB-2996 [CMD] TESEO update / downgrade failed
***********************************************************************/
#ifndef _TESEO_GLOBAL_H_
#define _TESEO_GLOBAL_H_

using namespace std;
#include <string>

#include "ai_osal_linux/components/system/system_types.h"

#define TESEO_SWUPDATE_MGR        ((tCString)"TESEO_SWUPDATE_MGR")
#define TESEO_SW_UPDATER          ((tCString)"TESEO_SW_UPDATER")
#define EV_TESEO_SWUPDATE_MGR   		   (0x01)
#define EV_TESEO_SW_UPDATER		  	 	   (0x02)
#define TESEO_FW_CHUNK_SIZE_BYTES_16K (16 * 1024) //16KB chunks - for teseo_2 update
#define TESEO_FW_CHUNK_SIZE_BYTES_5K (5 * 1024) //5KB chunks - for teseo_3 update
extern tU32 u32gTeseo_Fw_Chunk_Size_Bytes; 
extern string strTeseoVersionToGNSS;

#define DEVICE_NAME 			  "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS/TESEO"
#define APP_KEY_NAME			  "TESEO_FW_VERSION"
#define TESEO_CTRL_VERSION		  "1.0"

enum eTraceLevels {
  TRACE_LEVEL_1=1,
  TRACE_LEVEL_2
};

#define DBG_TRACE_ENABLED TRACE_LEVEL_2
#ifdef DBG_TRACE_ENABLED
#include <stdio.h>
#define DEBUG_TRACE(level,fmtstr, args...) \
	(level <= DBG_TRACE_ENABLED) ? printf("" fmtstr "\n", ##args) : 0;
#else
#define DEBUG_TRACE(fmtstr, args...)
#endif

typedef void (*T_fCallback)(tU32);

typedef enum{
	EV_TESEO_SWUPDATE_START=1,
	EV_TESEO_SWUPDATE_ABORT,
	EV_TESEO_SWUPDATE_EXIT,
	EV_INVALID
} enEvTeseoSWUpdateClientToMgr;

//Exit codes for teseo client APP
//These are used as internal error codes as well
typedef enum{
	TESEO_EXIT_SUCCESS=0,
	TESEO_SWUPDATE_SUCCESS=0,
	TESEO_EXIT_FAILED,
	TESEO_SWUPDATE_NOT_STARTED,
	TESEO_CLIENT_INTF_CREATION_OK,
	TESEO_SWUPDATE_STARTED,
	TESEO_SWUPDATE_FLASHING_FLASHER_BIN,
	TESEO_SWUPDATE_FLASHING_FIRMWARE,
	TESEO_SWUPDATE_ABORTED,
	TESEO_SWUPDATE_ABORT_FAILED,
	TESEO_FILE_CLOSE_ERROR,
	TESEO_OSAL_WRITE_ERROR,
	TESEO_OSAL_EVENT_ERROR,
	TESEO_SWUPDATE_IOCTL_ERROR,
	TESEO_SWUPDATE_CRC_ERROR,
	TESEO_SWUPDATE_GNSS_OPEN_ERROR,
	TESEO_SWUPDATE_GNSS_CLOSE_ERROR,
	TESEO_SWUPDATE_BL_OPEN_ERROR,
	TESEO_SWUPDATE_FW_OPEN_ERROR,
	TESEO_SWUPDATE_FW_CRCS_SAME,
	TESEO_SWUPDATE_FW_CRCS_DIFFERENT,
	TESEO_SWUPDATE_CRC_CALC_OK,
	TESEO_SWUPDATE_CRC_CALC_ERROR,
	TESEO_SWUPDATE_PARSE_CMDARGS_FAILED,
	TESEO_GNSS_NOTIFY_TYPE_ERROR,
	INVALID_STATE,
	TESEO_UPDTCTRL_VERSION=31 //value changes when teseo app cmd line args changes
} enTeseoSWUpdateState;

typedef enum{
	EV_TESEO_SWUPDATE_STATUS,
	EV_TESEO_FW_VER_INFO,
	EV_TESEO_INVALID
} enEvTeseoSWUpdaterToMgr;

typedef enum{
	STATUS_OK,
	STATUS_FAILED,
	STATUS_SWUPDATE_NOT_STARTED
} enSWUpdateStatus;

typedef enum {
	TESEO_CMD_ARG_BIN,
	TESEO_CMD_ARG_FIRMWARE,
	TESEO_CMD_ARG_CMPCRC,
	TESEO_CMD_ARG_GET_CRC_FROM_GNSS,
	TESEO_CMD_ARG_GET_CRC_FROM_UPDTCTRL,
	INVALID_ARG
} enTeseoCmdArgs;

#endif
