/************************************************************************
* File: teseo_ClientInterface.h
* SW-Component: 
*
* Description:
*	Provides interfaces for teseo DL client to initiate and control 
* 	teseo sw update 
* Author:
*   Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 14.10.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 27.08.2013 - Implemented CMG3G-5318 optimized logging using update.log - Apoorva K R (RBEI/ECA1)
* 6/4/2015 - Implemented CMG3G-6728 IS2030_Teseo update only if CRC changed@Integration Tooling - Apoorva K.R (RBEI/ECA1)
*---------------------------------------------------------------------------------------------------
* 1/2/2016          | AGL5KOR (RBEI)    |     CMG3G-9450 - teseo update ctrl app to be modified to write and read CRC
* 				    | Anusha Ghali	    | 
*---------------------------------------------------------------------------------------------------
***********************************************************************/
#ifndef _TESEO_CLIENT_HANDLER_H_
#define _TESEO_CLIENT_HANDLER_H_

#include "teseo_SWUpdateMgr.h"
#include "UpdateLog.h"

using namespace ::ai_sw_update::common;

class teseo_ClientInterface {
public:
	teseo_ClientInterface();
	virtual ~teseo_ClientInterface();

	tU8 bInitClientInterface(std::string& strFlasherPath,
						  std::string& strTeseoFWBinPath);
	tU8 u8InitClientInterfaceForCRC(std::string& strTeseoFWBinPath, \
			const std::string& strPathToFile, bool bCRCFromGNSS, \
					bool bCRCFromUpdtCtl, bool bFlasherCrc);	
	tBool bExitClientInterface();
	tU8 bOnStartSWUpdate(T_fCallback fptr_ClientCb);
	tBool bOnAbortSWUpdate() const;
	tBool bPostEvent() const; 
	
	tU8 bOnGetTeseoSWUpdateState() const;
	tU8 bOnGetTeseoSWUpdateStatus() const;
protected:
	teseo_SWUpdateMgr m_swUpdateMgr;
};

#endif //_TESEO_CLIENT_HANDLER_H_
