/************************************************************************
 * FILE: 			sxm_sirius_update.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	A server class to take calls for updating SXM firmware
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
 *  20.06.2016  Rev. 1.1 Logesh
 * 				Choose firmware from a dir based on HType.
************************************************************************/

#ifndef _SXM_SIRIUS_UPDATE_H_
#define _SXM_SIRIUS_UPDATE_H_

#include "sxm_enums.h"
#include "sxm_singleton.h"
#include <string>
#include "sxm_types.h"

namespace SiriusModuleUpdateControlLib {

#define MAX_SIZE_FIND_BUFFER 128

typedef tVoid (*cbProgressInformation) (tU8);
class SiriusModuleHandler;

class SiriusUpdate : public Singleton<SiriusUpdate>
{

private:
	SXM_ERROR_CODE_ENUM enSXMError;
	SXM_STATE_ENUM enSXMState;
	SiriusModuleHandler *_hSiriusModule;

	tBool isSiriusModuleHandleValid();
	tVoid initializeModuleHandlerIfNotInitialized();

public:
	SiriusUpdate();
	virtual ~SiriusUpdate();
	
	tVoid setSiriusModuleHandler(SiriusModuleHandler* _siriusModuleHandler);
	tVoid resetSXM();
	tBool initialize();
	tBool isInitialized();
	tBool updateFirmware(std::string l_firmwareFilePath, tBool bForceUpdate, cbProgressInformation);
	tBool deinitialize();
	SXM_ERROR_CODE_ENUM getError();

	tBool isFirmwareFitForHardware(std::string sFrimwarePath, std::string sHType);
	SXM_ERROR_CODE_ENUM chooseCompatibleFirmware(std::string sHardwareType, std::string sBasePath, std::string& sChosenBinary);
	tBool isFirmwareVersionNewer(std::string l_firmwareFilePath);
	
	std::string getSerialVersion();
	std::string getHardwareVersion();
	std::string getHardwareType();
	std::string getSoftwareVersion();
	std::string getFirmwareVersion(std::string l_firmwareFilePath);
	std::string getHardwareTypeFromFirmware(std::string l_firmwareFilePath);
	
};


} // namespace SiriusModuleUpdateControlLib


#endif // _SXM_SIRIUS_UPDATE_H_
