/************************************************************************
 * FILE: 			sxm_singleton.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	To make a class singleton.
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/



#ifndef _SXM_SINGLETON_H_
#define _SXM_SINGLETON_H_

namespace SiriusModuleUpdateControlLib {

template <typename C>
class Singleton {
public:
  static C* instance ()
  {
    if (!_instance) {
	_instance = new C;
    }
    return _instance;
  }
  virtual ~Singleton ()
  {
    _instance = 0;
  }

   bool hasInstance() {
      return _instance!=0;
   }

private:
  //lint -esym(1704, Singleton*::Singleton*) prio3 constructor has private access specification
  Singleton(const Singleton<C>&);
  Singleton& operator=(const Singleton<C>&);
  static C* _instance;
protected:
  Singleton () { }
  void setInstance(C* poThis) {
    _instance =poThis;
  }
};


template <typename C> C* Singleton <C>::_instance = 0;

} // namespace SiriusModuleUpdateControlLib

#endif //_SXM_SINGLETON_H_
