/************************************************************************
 * FILE: 			sxm_gpio.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	Interface for SXM controlling GPIOs
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/


 
#ifndef _SXM_GPIO_H_
#define _SXM_GPIO_H_


#include "sxm_types.h"

 
namespace SiriusModuleUpdateControlLib {
 
class SXM_GPIO
{
public:
	SXM_GPIO();
	virtual ~SXM_GPIO();
	virtual tBool initializeGPIOs() = 0;
	virtual tBool setPort(const tChar* pcGPIOPath, tBool bOn) = 0;
	virtual tBool setPower(tBool bOn) = 0;
	virtual tBool setReset(tBool bOn) = 0;
	virtual tBool initializeGPIO(const tChar* pcGPIOPath) = 0;
};

class tclSXM_GPIO : public SXM_GPIO
{

public:
	tclSXM_GPIO();
	virtual ~tclSXM_GPIO();
	
	tBool initializeGPIOs();

	//Write the specified value to successfully opened port
	tBool setPort(const tChar* pcGPIOPath, tBool bOn);
	//Switch on/off power to X65 module
	tBool setPower(tBool bOn);
	//Set High/low for reset pin of  to X65 module
	tBool setReset(tBool bOn);
	tBool initializeGPIO(const tChar* pcGPIOPath);
};


} // namespace SiriusModuleUpdateControlLib

#endif // _SXM_GPIO_H_

