/************************************************************************
 * FILE: 			sxm_gpio.cpp
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	GPIO implementation for contolling SXM hardware
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/

#include "sxm_gpio.h"
#include "sxm_update_log.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
	#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE_CTRL
	#define ETG_I_TTFIS_CMD_PREFIX 			"DNL_"
	#define ETG_I_FILE_PREFIX 				dl_tclSXM::
    #define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_SXM
  #include "trcGenProj/Header/sxm_gpio.cpp.trc.h"
#endif
#include "ai_sw_update/common/base/imp/swupd_trace.h"


#define GPIO_SXM_POWER_DIRECTION  	"/sys/class/boardcfg/boardcfg/cpu-shdn-xm/direction"
#define GPIO_SXM_RESET_DIRECTION  	"/sys/class/boardcfg/boardcfg/cpu-rst-xm/direction"
#define GPIO_SXM_POWER 				"/sys/class/boardcfg/boardcfg/cpu-shdn-xm/value"
#define GPIO_SXM_RESET 				"/sys/class/boardcfg/boardcfg/cpu-rst-xm/value"


using namespace SiriusModuleUpdateControlLib;
using namespace ::ai_sw_update::common;


/************************************************************************
 * FUNCTION: SXM_GPIO::SXM_GPIO
 *
 * DESCRIPTION: Empty Constructor
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
SXM_GPIO::SXM_GPIO() {}
/************************************************************************
 * FUNCTION: ffSXM_GPIO::~SXM_GPIO
 *
 * DESCRIPTION: Empty Destructor
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
SXM_GPIO::~SXM_GPIO() {}



/************************************************************************
 * FUNCTION: ftclSXM_GPIO::tclSXM_GPIO
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tclSXM_GPIO::tclSXM_GPIO()
{
}

/************************************************************************
 * FUNCTION: ftclSXM_GPIO::~tclSXM_GPIO
 *
 * DESCRIPTION: Destructor
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tclSXM_GPIO::~tclSXM_GPIO()
{
}

/************************************************************************
 * FUNCTION: tclSXM_GPIO::setPort
 *
 * DESCRIPTION: Set the GPIO ON / OFF
 *
 * PARAMETER:
 * 				const tChar*, tBool
 *
 * RETURNVALUE: functBool
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tBool tclSXM_GPIO::setPort(const tChar* pcGPIOPath, tBool bOn) {
	FILE *fp = fopen(pcGPIOPath, "rb+");
	tBool bResult = false;

	if (NULL != fp) {
		char cSigValue = (bOn) ? '1' : '0';
		rewind(fp);
		if(!fwrite(&cSigValue, sizeof(char), 1, fp))
		{
			ETG_TRACE_ERR(("Cannot write to %s", pcGPIOPath));
			UpdateLogError("Cannot write to %s", pcGPIOPath);
		}
		else
		{
			 bResult = true;
		}
		fclose(fp);
	} else {
		ETG_TRACE_ERR(("Cannot open %s", pcGPIOPath));
		UpdateLogError("Cannot open %s", pcGPIOPath);
		bResult = false;
	}
	return bResult;
}

/************************************************************************
 * FUNCTION: tclSXM_GPIO::setPower
 *
 * DESCRIPTION: Set power pin of SXM ON / OFF
 *
 * PARAMETER:
 * 				tBool
 *
 * RETURNVALUE: tBool
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tBool tclSXM_GPIO::setPower(tBool bOn) {
	return setPort(GPIO_SXM_POWER, bOn);
}

/************************************************************************
 * FUNCTION: tclSXM_GPIO::setReset
 *
 * DESCRIPTION: Set reset pin of SXM ON / OFF
 *
 * PARAMETER:
 * 				tBool
 *
 * RETURNVALUE: tBool
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tBool tclSXM_GPIO::setReset(tBool bOn) {
	return setPort(GPIO_SXM_RESET, bOn);
}


tBool tclSXM_GPIO::initializeGPIO(const tChar* pcGPIOPath)
/************************************************************************
 * FUNCTION: tclSXM_GPIO::initializeGPIO
 *
 * DESCRIPTION: Set GPIO direction to OUT
 *
 * PARAMETER:
 * 				const tChar*
 *
 * RETURNVALUE: tBool
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
{
	FILE *fp;
	fp = fopen(pcGPIOPath, "rb+");
	if (NULL == fp) {
	   return false;
	}

	char set_value[4];
	strcpy(set_value,"out");
	rewind(fp);
	fwrite(&set_value, sizeof(char), 3, fp);
	fclose(fp);
	return true;
}


/************************************************************************
 * FUNCTION: tclSXM_GPIO::initializeGPIOs
 *
 * DESCRIPTION: Set power and reset GPIOs direction to OUT
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE: tBool
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tBool tclSXM_GPIO::initializeGPIOs()
{
	tBool bResult;
	bResult = initializeGPIO(GPIO_SXM_POWER_DIRECTION);
	bResult &= initializeGPIO(GPIO_SXM_RESET_DIRECTION);
	return bResult;
}
