/************************************************************************
 * FILE: 			sxm_enums.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	Enums for SXM Update Control Library
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/

#ifndef _SXM_ENUMS_H_
#define _SXM_ENUMS_H_

namespace SiriusModuleUpdateControlLib {

typedef enum sxm_state_enum
{
	SXM_STATE_INVALID,
	SXM_STATE_INITIALIZED,
	SXM_STATE_UPDATING,
	SXM_STATE_UPDATE_SUCCESS,
	SXM_STATE_UPDATE_FAILURE,
	SXM_STATE_DEINITIALIZED

}SXM_STATE_ENUM;

typedef enum sxm_error_enum
{
    SXM_NO_ERROR = 0,
    SXM_ERROR_INVALID_ARGUMENTS,
    SXM_ERROR_POWER_ON_FAILURE,
    SXM_ERROR_DRIVER_INITIALIZATION_FAILURE,
    SXM_ERROR_INITIALIZATION_FAILURE,
    SXM_ERROR_NOT_INITIALIZED,
    SXM_ERROR_INVALID_SRM,
    SXM_ERROR_INVALID_MODULE,
    SXM_ERROR_DOWNGRADE_NOT_ALLOWED,
    SXM_ERROR_FILE_VERSION_INVALID,
    SXM_ERROR_UPDATE_IN_PROGRESS,
    SXM_ERROR_FIRMWARE_UPDATE_FAILED

} SXM_ERROR_CODE_ENUM;



} // namespace SiriusModuleUpdateControlLib


#endif // _SXM_ENUMS_H_
