/*******************************************************************************************
* FILE:			RecoveryHmiDefine.h
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:
*
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2014 - 2015 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					15.04.2014	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/

#ifndef RECOVERY_HMI_DEFINE_H
#define RECOVERY_HMI_DEFINE_H

#include "../fbhmi/fbhmi_Global.h"

//-----------------------------------------------------------------------------
// FBHMI defines
//-----------------------------------------------------------------------------
#define R_HMI_U32_BAR_MIN_VALUE               0
#define R_HMI_U32_BAR_MAX_VALUE				        100

#define R_HMI_MAX_LUA_OUTPUT_LINES								2
#define R_HMI_MAX_BUFFER_SIZE										255
#define R_HMI_LUA_OUTPUT_LINE_1                  0
#define R_HMI_LUA_OUTPUT_LINE_2                  1
#define R_HMI_MAX_SIZE_LUA_OUTPUT 43

// Common properties
#define R_HMI_FBHMI_FIX_TEXT_FG_COLOR					FBHMI_COLOR_RED
#define R_HMI_FBHMI_FIX_TEXT_BG_COLOR					FBHMI_COLOR_BLACK
#define R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR			R_HMI_FBHMI_FIX_TEXT_BG_COLOR
#define R_HMI_FBHMI_FIX_TEXT_ALIGN						FBHMI_TXT_ALIGN_LEFT
#define R_HMI_FBHMI_FIX_TEXT_VISIBILITY				FBHMI_WIDGET_SHOWN


#define R_HMI_FBHMI_VAR_TEXT_FG_COLOR					FBHMI_COLOR_WHITE
#define R_HMI_FBHMI_VAR_TEXT_BG_COLOR					FBHMI_COLOR_BLACK
#define R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR			R_HMI_FBHMI_VAR_TEXT_BG_COLOR
#define R_HMI_FBHMI_VAR_TEXT_ALIGN						FBHMI_TXT_ALIGN_LEFT
#define R_HMI_FBHMI_VAR_TEXT_VISIBILITY				FBHMI_WIDGET_SHOWN

#define R_HMI_FBHMI_SCREEN_TEXT_COLOR					FBHMI_COLOR_BROWN
#define R_HMI_FBHMI_SCREEN_BG_COLOR					FBHMI_COLOR_BLACK
#define R_HMI_FBHMI_SCREEN_BORDER_COLOR				FBHMI_COLOR_BLUE

// Screen parameters.
#define R_HMI_FBHMI_LABEL_HEIGHT						20
#define R_HMI_FBHMI_PBAR_MAX_SIZE						100
#define R_HMI_FBHMI_SCREEN_WIDTH						400
#define R_HMI_FBHMI_SCREEN_HEIGHT						240
#define R_HMI_FBHMI_SCREEN_BWIDTH						6

// Source parameters.
#define R_HMI_FBHMI_SRC_FIX_TEXT_X						15
#define R_HMI_FBHMI_SRC_FIX_TEXT_Y						15
#define R_HMI_FBHMI_SRC_FIX_TEXT_WIDTH				45
#define R_HMI_FBHMI_SRC_FIX_TEXT_HEIGHT				15
#define R_HMI_FBHMI_SRC_FIX_TEXT_BWIDTH				0

#define R_HMI_FBHMI_SRC_VAR_TEXT_X						(R_HMI_FBHMI_SRC_FIX_TEXT_X + R_HMI_FBHMI_SRC_FIX_TEXT_WIDTH)
#define R_HMI_FBHMI_SRC_VAR_TEXT_Y						R_HMI_FBHMI_SRC_FIX_TEXT_Y
#define R_HMI_FBHMI_SRC_VAR_TEXT_WIDTH				120
#define R_HMI_FBHMI_SRC_VAR_TEXT_HEIGHT				15
#define R_HMI_FBHMI_SRC_VAR_TEXT_BWIDTH				0

// Status parameters
#define R_HMI_FBHMI_STAT_FIX_TEXT_X					15
#define R_HMI_FBHMI_STAT_FIX_TEXT_Y					35
#define R_HMI_FBHMI_STAT_FIX_TEXT_WIDTH				45
#define R_HMI_FBHMI_STAT_FIX_TEXT_HEIGHT				15
#define R_HMI_FBHMI_STAT_FIX_TEXT_BWIDTH				0

#define R_HMI_FBHMI_STAT_VAR_TEXT_X					(R_HMI_FBHMI_STAT_FIX_TEXT_X + R_HMI_FBHMI_STAT_FIX_TEXT_WIDTH)
#define R_HMI_FBHMI_STAT_VAR_TEXT_Y					R_HMI_FBHMI_STAT_FIX_TEXT_Y
#define R_HMI_FBHMI_STAT_VAR_TEXT_WIDTH				300
#define R_HMI_FBHMI_STAT_VAR_TEXT_HEIGHT				15
#define R_HMI_FBHMI_STAT_VAR_TEXT_BWIDTH				0

// System parameters
#define R_HMI_FBHMI_SYS_FIX_TEXT_X						200
#define R_HMI_FBHMI_SYS_FIX_TEXT_Y						15
#define R_HMI_FBHMI_SYS_FIX_TEXT_WIDTH				45
#define R_HMI_FBHMI_SYS_FIX_TEXT_HEIGHT				15
#define R_HMI_FBHMI_SYS_FIX_TEXT_BWIDTH				0

#define R_HMI_FBHMI_SYS_VAR_TEXT_X						(R_HMI_FBHMI_SYS_FIX_TEXT_X + R_HMI_FBHMI_SYS_FIX_TEXT_WIDTH)
#define R_HMI_FBHMI_SYS_VAR_TEXT_Y						R_HMI_FBHMI_SYS_FIX_TEXT_Y
#define R_HMI_FBHMI_SYS_VAR_TEXT_WIDTH					145
#define R_HMI_FBHMI_SYS_VAR_TEXT_HEIGHT				15
#define R_HMI_FBHMI_SYS_VAR_TEXT_BWIDTH				0

// System version parameters
#define R_HMI_FBHMI_SYSVER_VAR_TEXT_X					10
#define R_HMI_FBHMI_SYSVER_VAR_TEXT_Y					65
#define R_HMI_FBHMI_SYSVER_VAR_TEXT_WIDTH			380
#define R_HMI_FBHMI_SYSVER_VAR_TEXT_HEIGHT			15
#define R_HMI_FBHMI_SYSVER_VAR_TEXT_BWIDTH			0

// Lua output line 1
#define R_HMI_FBHMI_LUAOUT_1_X							15
#define R_HMI_FBHMI_LUAOUT_1_Y							95
#define R_HMI_FBHMI_LUAOUT_1_WIDTH						350
#define R_HMI_FBHMI_LUAOUT_1_HEIGHT					15
#define R_HMI_FBHMI_LUAOUT_1_BWIDTH					0

// Lua output line 2
#define R_HMI_FBHMI_LUAOUT_2_X							15
#define R_HMI_FBHMI_LUAOUT_2_Y							110
#define R_HMI_FBHMI_LUAOUT_2_WIDTH						350
#define R_HMI_FBHMI_LUAOUT_2_HEIGHT					15
#define R_HMI_FBHMI_LUAOUT_2_BWIDTH					0

// Lua command parameters
#define R_HMI_FBHMI_LUA_FIX_CMD_X						15
#define R_HMI_FBHMI_LUA_FIX_CMD_Y						215
#define R_HMI_FBHMI_LUA_FIX_CMD_WIDTH					55
#define R_HMI_FBHMI_LUA_FIX_CMD_HEIGHT				15
#define R_HMI_FBHMI_LUA_FIX_CMD_BWIDTH				0

#define R_HMI_FBHMI_LUA_VAR_CMD_X						(R_HMI_FBHMI_LUA_FIX_CMD_X + R_HMI_FBHMI_LUA_FIX_CMD_WIDTH)
#define R_HMI_FBHMI_LUA_VAR_CMD_Y						R_HMI_FBHMI_LUA_FIX_CMD_Y
#define R_HMI_FBHMI_LUA_VAR_CMD_WIDTH					225
#define R_HMI_FBHMI_LUA_VAR_CMD_HEIGHT				15
#define R_HMI_FBHMI_LUA_VAR_CMD_BWIDTH				0

// File name parameters
#define R_HMI_FBHMI_FILE_FIX_TEXT_X					15
#define R_HMI_FBHMI_FILE_FIX_TEXT_Y					200
#define R_HMI_FBHMI_FILE_FIX_TEXT_WIDTH				45
#define R_HMI_FBHMI_FILE_FIX_TEXT_HEIGHT				15
#define R_HMI_FBHMI_FILE_FIX_TEXT_BWIDTH				0

#define R_HMI_FBHMI_FILE_VAR_TEXT_X					(R_HMI_FBHMI_FILE_FIX_TEXT_X + R_HMI_FBHMI_FILE_FIX_TEXT_WIDTH)
#define R_HMI_FBHMI_FILE_VAR_TEXT_Y					R_HMI_FBHMI_FILE_FIX_TEXT_Y
#define R_HMI_FBHMI_FILE_VAR_TEXT_WIDTH				175
#define R_HMI_FBHMI_FILE_VAR_TEXT_HEIGHT				15
#define R_HMI_FBHMI_FILE_VAR_TEXT_BWIDTH				0

// Elapsed time parameters
#define R_HMI_FBHMI_ELAPSE_TIME_X_OFFSET				60
#define R_HMI_FBHMI_ELAPSE_TIME_Y_OFFSET				0
#define R_HMI_FBHMI_ELAPSE_TIME_WIDTH					32
#define R_HMI_FBHMI_ELAPSE_TIME_HEIGHT				15
#define R_HMI_FBHMI_ELAPSE_TIME_BWIDTH				0
#define R_HMI_FBHMI_ELAPSE_TIME_ALIGN					FBHMI_TXT_ALIGN_CENTER

// Progress Bar
#define R_HMI_FBHMI_PROGRESS_BAR_X						100
#define R_HMI_FBHMI_PROGRESS_BAR_Y						130
#define R_HMI_FBHMI_PROGRESS_BAR_WIDTH				200
#define R_HMI_FBHMI_PROGRESS_BAR_HEIGHT				30
#define R_HMI_FBHMI_PROGRESS_BAR_BWIDTH				2
#define R_HMI_FBHMI_PROGRESS_BAR_BG_COLOR			FBHMI_COLOR_BLACK
#define R_HMI_FBHMI_PROGRESS_BAR_FG_COLOR			FBHMI_COLOR_RED
#define R_HMI_FBHMI_PROGRESS_BAR_BORDER_COLOR		FBHMI_COLOR_RED
#define R_HMI_FBHMI_PROGRESS_BAR_FILL_COLOR			FBHMI_COLOR_WHITE
#define R_HMI_FBHMI_PROGRESS_BAR_MIN_VALUE			0
#define R_HMI_FBHMI_PROGRESS_BAR_MAX_VALUE			100
#define R_HMI_FBHMI_PROGRESS_BAR_LABEL_ALIGN		FBHMI_TXT_ALIGN_CENTER
#define R_HMI_FBHMI_PROGRESS_BAR_VISIBILITY			FBHMI_WIDGET_SHOWN

// Progress Bar
#define R_HMI_FBHMI_AIVI_FIX_TEXT_X                 (R_HMI_FBHMI_PROGRESS_BAR_X-50)
#define R_HMI_FBHMI_AIVI_FIX_TEXT_Y                 (R_HMI_FBHMI_PROGRESS_BAR_Y+R_HMI_FBHMI_PROGRESS_BAR_HEIGHT+8)//(R_HMI_FBHMI_STAT_VAR_TEXT_Y+48)
#define R_HMI_FBHMI_AIVI_FIX_TEXT_WIDTH             (R_HMI_FBHMI_PROGRESS_BAR_WIDTH+100)
#define R_HMI_FBHMI_AIVI_FIX_TEXT_HEIGHT            15
#define R_HMI_FBHMI_AIVI_FIX_TEXT_BWIDTH            0

// Ota Progress Bar
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_X						100
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_Y						130
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_WIDTH				240
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_HEIGHT				14
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_BWIDTH				1
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_BG_COLOR			FBHMI_COLOR_BLACK
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_FG_COLOR		    FBHMI_COLOR_GREY
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_BORDER_COLOR		FBHMI_COLOR_GREY
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_FILL_COLOR			FBHMI_COLOR_BLUE
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_MIN_VALUE			0
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_MAX_VALUE			100
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_LABEL_ALIGN		FBHMI_TXT_ALIGN_CENTER
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_VISIBILITY			FBHMI_WIDGET_SHOWN
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_FAILED_FILL_COLOR  FBHMI_COLOR_RED
#define R_HMI_FBHMI_OTA_PROGRESS_BAR_SUCESS_FILL_COLOR  FBHMI_COLOR_GREEN

#define R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_X              320
#define R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_Y			  110
#define R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_WIDTH		   20
#define R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_HEIGHT		   15
#define R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_BWIDTH		   0

//ota Failure Crosss
#define R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_X   	    210
#define R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_Y	        110
#define R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_WIDTH		 30
#define R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_HEIGHT		 15
#define R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_BWIDTH		 0


// List of Screens, currently only one
enum enScreenList {
	R_HMI_PRIMARY_SCREEN,
};

//fbhmi widget Ids
enum enWidgetIds
{
	R_HMI_EN_TITLE_ID,
	R_HMI_EN_ELAPSED_TIME_ID,
	R_HMI_EN_DNL_PBAR_ID,
	R_HMI_EN_SOURCE_FIXED_TEXT_ID,
	R_HMI_EN_SOURCE_VAR_TEXT_ID,
	R_HMI_EN_STATUS_FIXED_TEXT_ID,
	R_HMI_EN_STATUS_VAR_TEXT_ID,
	R_HMI_EN_FILE_NAME_FIXED_TEXT_ID,
	R_HMI_EN_FILE_NAME_VAR_TEXT_ID,
	R_HMI_EN_SYSTEM_TYPE_FIXED_TEXT_ID,
	R_HMI_EN_SYSTEM_TYPE_VAR_TEXT_ID,
	R_HMI_EN_SYSTEM_VERSION_TEXT_ID,
	R_HMI_EN_LUA_OUTPUT_LINE_1_TEXT_ID,
	R_HMI_EN_LUA_OUTPUT_LINE_2_TEXT_ID,
	R_HMI_EN_LUA_COMMAND_FIXED_TEXT_ID,
	R_HMI_EN_LUA_COMMAND_VAR_TEXT_ID,
   R_HMI_EN_AIVI_FIXED_TEXT_ID,
	R_HMI_EN_OTA_PROGRESS_VAR_TEXT_ID,
	R_HMI_EN_OTA_FAILURE_FIXED_TEXT_ID
};

enum R_HMI_FBHMI_STATE_TYPE
{
    R_HMI_EN_STATE_IDLE,
    R_HMI_EN_STATE_NOT_READY,
    R_HMI_EN_STATE_SELECT_SOURCE,
    R_HMI_EN_STATE_SELECT_RELEASE,
    R_HMI_EN_STATE_CONFIG,
    R_HMI_EN_STATE_RUNNING,
    R_HMI_EN_STATE_ERROR,
    R_HMI_EN_STATE_SKIPPING,
    R_HMI_EN_STATE_ABORTING,
    R_HMI_EN_STATE_RESULT,
    R_HMI_EN_STATE_REBOOT
};

struct stRecoveryHmiInterface
{
	R_HMI_FBHMI_STATE_TYPE enumHmiState;
	_tUInt uintProgress;
	_tChar ArrPlatformVer[R_HMI_MAX_BUFFER_SIZE]; // platform version
	_tChar ArrSourceType[R_HMI_MAX_BUFFER_SIZE];     // System type: FCID
	_tChar ArrSysType[R_HMI_MAX_BUFFER_SIZE];     // System type: FCID
	_tChar ArrTargetSysVer[R_HMI_MAX_BUFFER_SIZE];      // System version present in target "old ver"
	_tChar ArrMediaSysVer[R_HMI_MAX_BUFFER_SIZE];      // System version present in media "New Ver"
	_tChar ArrFileName[R_HMI_MAX_BUFFER_SIZE];    // File name
	_tChar ArrElapseTime[R_HMI_MAX_BUFFER_SIZE];  // Elapsed time
	_tChar ArrLUACmd[R_HMI_MAX_BUFFER_SIZE];      // LUA script command
	_tChar ArrLUAOutput[R_HMI_MAX_LUA_OUTPUT_LINES][R_HMI_MAX_BUFFER_SIZE];   // LUA script echo..

};


#endif //RECOVERY_HMI_DEFINE_H

