/************************************************************************
* File: fbhmi_Global.h
*
* Description:
*   Contains all the commonly used data types, macros and headers used
*   in the hmi code.
* Author:
*   Gururaj.B@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 30.05.2013 - Initial version - Gururaj.B@in.bosch.com
* 08.09.2014 - Added FBHMI_EVNT_UPDATE_TITLE event - Apoorva K R
***********************************************************************/

#ifndef _FBHMI_GLOBAL_H_
#define _FBHMI_GLOBAL_H_

#define FBHMI_FRAMEBUFF_DEVICE "/dev/fb0"
#define FBHMI_KMS_DEVICE "/dev/dri/card0"
#define FBHMI_6x10_FONT_FILE "/usr/share/fonts/6x10.bdf"
#define FBHMI_10x20_FONT_FILE "/usr/share/fonts/10x20.bdf"

/**!!!!!!!!!!!! Please check if this is corret or not
Added by Ankur */
#define FBHMI_BYTES_PER_PIXEL 4
#define FBHMI_ZERO 0

// Screen defines
#define FBHMI_SCREEN_DEF_ID			0
#define FBHMI_SCREEN_DEF_X			0
#define FBHMI_SCREEN_DEF_Y			0
#define FBHMI_SCREEN_DEF_WIDTH		400
#define FBHMI_SCREEN_DEF_HEIGHT		240
#define FBHMI_SCREEN_DEF_TITLE_X	0
#define FBHMI_SCREEN_DEF_TITLE_Y	0

// Widget defaults
#define FBHMI_WIDGET_DEF_ID			0x00
#define FBHMI_WIDGET_DEF_X			0x00
#define FBHMI_WIDGET_DEF_Y			0x00
#define FBHMI_WIDGET_DEF_HEIGHT		0x00
#define FBHMI_WIDGET_DEF_WIDTH		0x00
#define FBHMI_WIDGET_DEF_BWIDTH		0x00
#define FBHMI_WIDGET_DEF_BGCOLOR	FBHMI_COLOR_BLACK
#define FBHMI_WIDGET_DEF_FGCOLOR	FBHMI_COLOR_WHITE
#define FBHMI_WIDGET_DEF_BDRCOLOR	FBHMI_COLOR_BLACK
#define FBHMI_WIDGET_DEF_FILCOLOR	FBHMI_COLOR_BLACK
#define FBHMI_WIDGET_DEF_TEXT		"------"
#define FBHMI_WIDGET_DEF_ALIGN		FBHMI_TXT_ALIGN_CENTER
#define FBHMI_WIDGET_DEF_VISIBLE	true
#define FBHMI_WIDGET_DEF_PBARVAL	0
#define FBHMI_WIDGET_DEF_PBARMAX	100

typedef int _tS32;
typedef unsigned int _tU32;
typedef bool _tBool;
typedef char _tChar;
typedef unsigned char _tU8;
typedef void _tVoid;
typedef long _tS64;
typedef unsigned long _tU64;
typedef unsigned short _tU16;
typedef const char*   _tCString;
typedef unsigned int  _tUInt;
#ifndef TRUE
#define TRUE true
#endif
#ifndef FALSE
#define FALSE false
#endif

#undef DBG_ENABLED
#ifdef DBG_ENABLED
#include <stdio.h>
#define DEBUG_TRACE(fmtstr, args...) \
do { \
printf("\n%s " fmtstr "\n",__func__ , ##args); \
} while (0);
#else
#define DEBUG_TRACE(fmtstr, args...)
#endif


enum fbhmiEvent {
    FBHMI_EVNT_NONE,
    FBHMI_EVNT_CREATE_LABEL,
    FBHMI_EVNT_CREATE_PROGRESSBAR,
    FBHMI_EVNT_CREATE_SCREEN,
    FBHMI_EVNT_CLEAR_SCREEN,
    FBHMI_EVNT_UPDATE_COLOR,
    FBHMI_EVNT_UPDATE_DIMENSION,
    FBHMI_EVNT_UPDATE_PROGRESSBAR,
    FBHMI_EVNT_UPDATE_POSITION,
    FBHMI_EVNT_UPDATE_TEXT,
    FBHMI_EVNT_UPDATE_TEXT_ALIGN,
    FBHMI_EVNT_UPDATE_VISIBILITY,
    FBHMI_EVNT_DRAW_SCREEN,
    FBHMI_EVNT_UPDATE_TITLE
};

enum fbhmiTextAlign {
    FBHMI_TXT_ALIGN_LEFT,
    FBHMI_TXT_ALIGN_CENTER,
    FBHMI_TXT_ALIGN_RIGHT
};

enum fbhmiWidgetVisibility {
	FBHMI_WIDGET_HIDDEN,
	FBHMI_WIDGET_SHOWN
};

enum fbhmiUpdateType
{
    FBHMI_NON_OTA_UPDATE,
    FBHMI_OTA_UPDATE
};

enum fbhmiDisplayType
{
    FBHMI_DISPLAY_FB,
    FBHMI_DISPLAY_KMS
};

/** Referance Ubuntu's rgb.txt*/
/** each define is combination of  alpha|red|green|blue
By default alpha is kept zero */
#define FBHMI_COLOR_RED                         0x00FF0000
#define FBHMI_COLOR_GREEN                       0x0000FF00
#define FBHMI_COLOR_BLUE                        0x000000FF

#define FBHMI_COLOR_WHITE                       0x00FFFFFF
#define FBHMI_COLOR_BLACK                       0x00000000
#define FBHMI_COLOR_ORANGE                      0x00FFA500
#define FBHMI_COLOR_YELLOW                      0x00FFFF00
#define FBHMI_COLOR_PINK                        0x00FFC0CB
#define FBHMI_COLOR_BROWN                       0x00A52A2A
#define FBHMI_COLOR_PURPLE                      0x00A020F0
#define FBHMI_COLOR_GREY                        0x00BEBEBE

#endif /* _FBHMI_GLOBAL_H_ */
