/************************************************************************
 * File: fbhmi_GfxHandler.h
 * SW-Component: ASCII HMI for recovery download
 *
 ***********************************************************************/
#ifndef _FBHMI_GFXHANDLER_
#define _FBHMI_GFXHANDLER_
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>
#include <linux/fb.h>
#include <iostream>
#include "fbhmi_Global.h"
using namespace std;

class fbhmi_GfxHandler
{
protected:
  static fbhmi_GfxHandler *m_pGfxHandle;
  _tU32 m_u32YRes, m_u32XRes;
  struct fb_fix_screeninfo m_stGfxFix;
  struct fb_var_screeninfo m_stGfxVar;
  _tU8 *m_pGfxMemory;
  _tU8 *m_pGfxMemReal;
  _tU64 m_u64GfxMemOffset;
  _tU32 m_u32GfxPixelBytes;
  _tBool m_bVirtualGfx;

  static void     SigHandler(int Sig);
  void            vDisableCursor();
  _tS32           s32ReadFileContent(char * pchFilePath, char * acTempBuff);
  static void     ScreenShot(const char *FileName);
  fbhmi_GfxHandler();

public:
  virtual         ~fbhmi_GfxHandler();
  static fbhmi_GfxHandler*  pGetInstance();
  _tVoid          vClearScreen();
  _tU32           u32GetXRes();
  _tU32           u32GetYRes();
  _tVoid          vSetPixel(_tU32 u32x, _tU32 u32y, _tU32 u32Rgba);
  _tU32           vGetPixel(_tU32 u32x, _tU32 u32y);
};
#endif

