/************************************************************************
* File: fbhmi_FbHmiManager.h
* SW-Component: Text HMI for Recovery Downloader
*
* Description:
*   This is a basic window manager implementation for
*   framebuffer based text hmi display.
* Author:
*   Gururaj.B@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 30.05.2013 - Initial version - Gururaj.B@in.bosch.com
* 08.09.2014 - Added bUpdateTitle() to process the screen title text change - Apoorva K R
*
***********************************************************************/
#ifndef _FBHMI_FBHMIMANAGER_H_
#define _FBHMI_FBHMIMANAGER_H_

// System Libraries
#include <vector>
#include <pthread.h>
using namespace std;

// Local includes
#include "Fonts/fbhmi_Font.h"
#include "fbhmi_Global.h"
#include "fbhmi_QueueHandler.h"
#include "fbhmi_Surface.h"
#include "Widgets/fbhmi_Screen.h"
#include "Widgets/fbhmi_Widget.h"
#include "Requests/fbhmi_ColorReq.h"
#include "Requests/fbhmi_DimensionReq.h"
#include "Requests/fbhmi_PositionReq.h"
#include "Requests/fbhmi_ProgressReq.h"
#include "Requests/fbhmi_Request.h"
#include "Requests/fbhmi_TextReq.h"
#include "Requests/fbhmi_WidgetReq.h"


// Forward declaration
class fbhmi_Screen;
class fbhmi_Surface;
class fbhmi_Font;
class fbhmi_QueueHandler;


class fbhmi_FbHmiManager {

public:
	fbhmi_FbHmiManager(_tU32 u32Width = FBHMI_SCREEN_DEF_WIDTH,
		_tU32 u32Height = FBHMI_SCREEN_DEF_HEIGHT,
		_tU32 u32BdrWidth = FBHMI_WIDGET_DEF_BWIDTH,
		std::string	strTitle = FBHMI_WIDGET_DEF_TEXT,
		_tU32 u32FgColor = FBHMI_COLOR_WHITE,
		_tU32 u32BgColor = FBHMI_COLOR_BLACK,
		_tU32 u32BdrColor = FBHMI_COLOR_BLACK,
    _tU32 u32UpdateType = FBHMI_NON_OTA_UPDATE,
    fbhmiDisplayType u32DisplayType = FBHMI_DISPLAY_FB);
	~fbhmi_FbHmiManager();

	_tBool bInitHMIManager();
	_tBool bIsManagerInit() const;

	_tBool bCreateLabel(_tU16 u16ScreenId, _tU16 u16WidgetId, _tU32 u32x, _tU32 u32y,
		_tU32 u32Width, _tU32 u32Height, _tU32 u32BdrWidth, _tU32 u32FgColor,
		_tU32 u32BgColor, _tU32 u32BdrColor, string strText,
		_tU8 u8Align, _tBool bVisible) const;

	_tBool bCreateProgressBar(_tU16 u16ScreenId, _tU16 u16WidgetId, _tU32 u32x, _tU32 u32y,
		_tU32 u32Width, _tU32 u32Height, _tU32 u32BdrWidth, _tU32 u32FgColor,
		_tU32 u32BgColor, _tU32 u32BdrColor, string strText,
		_tU8 u8Align, _tBool bVisible, _tU32 u32Value, _tU32 u32MaxValue, _tU32 u32FillColor) const;

	_tBool bCreateScreen(_tU16 u16ScreenId, _tU32 u32x, _tU32 u32y,
		_tU32 u32Width,_tU32 u32Height, _tU32 u32BdrWidth, _tU32 u32FgColor,
		_tU32 u32BgColor, _tU32 u32BdrColor, string strText,
		_tU8 u8Align, _tBool bVisible, _tU32 u32FillColor);

	_tBool bClearScreen(_tU16 u16ScreenId) const;

	//_tBool bClearWidget(_tU16 u16ScreenId, _tU16 u16WidgetId);
	fbhmi_Screen * pclGetScreen(_tU16 u16ScreenId);

	_tBool bUpdateColor(_tU16 u16ScreenId, _tU16 u16WidgetId,
		_tU32 u32BgColor, _tU32 u32FgColor,
		_tU32 u32BdrColor, _tU32 u32FillColor) const;

	_tBool bUpdateDimension(_tU16 u16ScreenId, _tU16 u16WidgetId,
		_tU32 u32Width, _tU32 u32Height,
		_tU32 u32BdrWidth) const;

	_tBool bUpdateProgress(_tU16 u16ScreenId, _tU16 u16WidgetId, _tU32 u32Value, _tU32 u32MaxValue) const;
	_tBool bUpdatePosition(_tU16 u16ScreenId, _tU16 u16WidgetId, _tU32 u32x, _tU32 u32y) const;
	_tBool bUpdateText(_tU16 u16ScreenId, _tU16 u16WidgetId, string strText, _tU8 u8Align, _tBool bVisible) const;
	_tBool bDrawScreen(_tU16 u16ScreenId) const;
	_tBool bUpdateTitle(_tU16 u16ScreenId, string strText, _tU8 u8Align, _tBool bVisible) const;
	_tU32 u32GetXRes();
	_tU32 u32GetYRes();

	static fbhmi_QueueHandler* pclGetQueueHandle();

private:
	// Private data members
	static fbhmi_QueueHandler* m_pQueueHandle;
	fbhmi_Surface*	m_pSurfaceHandle;
	fbhmi_Font*		m_pFontHandle;
	vector <fbhmi_Screen*> m_vecScreenList;
	_tBool m_bManagerInit;
	pthread_t  m_stFbHmiThread;
	_tU32 m_u32xRes;
	_tU32 m_u32yRes;

	// Private methods
	static _tVoid* vFbHMIThreadCallback(_tVoid* arg)
	{
		reinterpret_cast<fbhmi_FbHmiManager *>(arg)->vFbHMIThreadFunction();
		return NULL;
	}
	_tVoid vFbHMIThreadFunction();
	_tVoid vProcessFbHMIEvent(fbhmi_Request* pReq);
};

#endif
