/************************************************************************
* File: fbhmi_Widget.h
* SW-Component: 
* Description: The base class for all widgets contains generic widget functionality.
* Author:
*	Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 01.08.2013 - Added define for dot size - Ankur Tank
***********************************************************************/

#ifndef _FBHMI_WIDGET_H_
#define _FBHMI_WIDGET_H_

#include "../fbhmi_Color.h"
#include "../fbhmi_Global.h"
#include "../fbhmi_ReqIf.h"
#include "../fbhmi_Surface.h"
#include "../fbhmi_Utility.h"
#include "../Requests/fbhmi_Request.h"
#include <stdio.h>
#include <stdlib.h>

#define LABELTXT_TRAILING_DOT_SIZE    3

class fbhmi_Surface;

class fbhmi_Widget
{

public:
    _tU16 m_u16Id;
    _tU32 m_u32x;
    _tU32 m_u32y;
    _tU32 m_u32Height;
    _tU32 m_u32Width;
    _tU16 m_u16BdrWidth;
    _tU32 m_u32BgColor;
    _tU32 m_u32FgColor;
    _tU32 m_u32BdrColor;
    _tU32 m_u32FillColor;
    std::string m_strText;
    _tU8 m_u8Align;
    _tBool m_bVisible;
    _tU32 m_u32PbarVal;
    _tU32 m_u32PbarMax;

    fbhmi_Surface* m_pSurfaceHandle;

    fbhmi_Widget(_tU16 u16Id = FBHMI_WIDGET_DEF_ID,
        _tU32 u32x = FBHMI_WIDGET_DEF_X,
        _tU32 u32y = FBHMI_WIDGET_DEF_Y,
        _tU32 u32Height = FBHMI_WIDGET_DEF_HEIGHT,
        _tU32 u32Width = FBHMI_WIDGET_DEF_WIDTH,
        _tU16 u16BdrWidth = FBHMI_WIDGET_DEF_BWIDTH,
        _tU32 u32BgColor = FBHMI_WIDGET_DEF_BGCOLOR,
        _tU32 u32FgColor = FBHMI_WIDGET_DEF_FGCOLOR,
        _tU32 u32BdrColor = FBHMI_WIDGET_DEF_BDRCOLOR,
        _tU32 u32FillColor = FBHMI_WIDGET_DEF_FILCOLOR,
        string sText = FBHMI_WIDGET_DEF_TEXT,
        _tU8 u8Align = FBHMI_WIDGET_DEF_ALIGN,
        _tBool bVisible = FBHMI_WIDGET_DEF_VISIBLE,
        _tU32 u32PbarVal = FBHMI_WIDGET_DEF_PBARVAL,
        _tU32 u32PbarMax = FBHMI_WIDGET_DEF_PBARMAX);
    fbhmi_Widget(fbhmi_Request *pReq);

    virtual ~fbhmi_Widget();

    virtual _tVoid vDrawWidget() = 0;
    virtual _tVoid vClearWidget(_tU32 u32ClearColor);
    virtual _tVoid vUpdateWidget(fbhmi_Request* pReq);
    virtual _tVoid vGetAlignedXY(_tU32* pu32AlndX, _tU32 *pu32AlndY, _tU32 u32Strlen);
};

#endif 
