/************************************************************************
 * File: fbhmi_ProgressBar.h
 * SW-Component: 
 * Description: implements ProgressBar functionality.
 * Author:
 *	Rohit.ChannappiahRaman@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
 ***********************************************************************/

#ifndef _FBHMI_PROGRESSBAR_H_
#define _FBHMI_PROGRESSBAR_H_

#include <string>
#include <pthread.h>
#include <sys/syscall.h>
#include "../fbhmi_Global.h"
#include "../fbhmi_Surface.h"
#include "fbhmi_Widget.h"

#define MAX_RECTANGLES	12
#define RECTANGLE_WIDTH	20

class fbhmi_ProgressBar : public fbhmi_Widget
{
public:
    fbhmi_ProgressBar(_tU16 m_u16Id,
    _tU32 m_u32x,
    _tU32 m_u32y,
    _tU32 m_u32Height,
    _tU32 m_u32Width,
    _tU16 m_u16BdrWidth,
    _tU32 m_u32BgColor,
    _tU32 m_u32FgColor,
    _tU32 m_u32BdrColor,
    _tU32 m_u32FillColor,
    std::string m_strText,
    _tU8 m_u8Align,
    _tBool m_bVisible,
    _tU32 m_u32PbarVal,
    _tU32 m_u32PbarMax);

    fbhmi_ProgressBar(fbhmi_Request *pReq);

    virtual ~fbhmi_ProgressBar();

    virtual _tVoid vDrawWidget();

    _tVoid vUpdateValues(_tU32 u32PbarVal, _tU32 u32MaxValue);
	_tU32 u32GetBarFillWidth();
};
#endif

