/************************************************************************
* File: fbhmi_Label.cpp
* SW-Component: 
* Description: The label widget provides all functionalities of a label
* Author:
*	Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 01.08.2013 - Fix for text clear issue - Ankur Tank
***********************************************************************/
#include "fbhmi_Label.h"
#include "../fbhmi_Global.h"
#include <string.h>
#include <stdlib.h>

class fbhmi_Widget;

//#define SURFACE fbhmi_Surface::pGetInstance()

/************************************************************************
* FUNCTION: fbhmi_Label::fbhmi_Label()
*
* DESCRIPTION: Parameterized Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Label::fbhmi_Label(_tU16 u16Id = FBHMI_WIDGET_DEF_ID,
                         _tU32 u32X = FBHMI_WIDGET_DEF_X,
                         _tU32 u32Y = FBHMI_WIDGET_DEF_Y,
                         _tU32 u32Height = FBHMI_WIDGET_DEF_HEIGHT,
                         _tU32 u32Width = FBHMI_WIDGET_DEF_WIDTH,
                         _tU16 u16BdrWidth = FBHMI_WIDGET_DEF_BWIDTH,
                         _tU32 u32BgColor = FBHMI_WIDGET_DEF_BGCOLOR,
                         _tU32 u32FgColor = FBHMI_WIDGET_DEF_FGCOLOR,
                         _tU32 u32BdrColor = FBHMI_WIDGET_DEF_BDRCOLOR,
                         _tU32 u32FillColor = FBHMI_WIDGET_DEF_FILCOLOR,
                         string sText = FBHMI_WIDGET_DEF_TEXT,
                         _tU8 u8Align = FBHMI_WIDGET_DEF_ALIGN,
                         _tBool bVisible = FBHMI_WIDGET_DEF_VISIBLE,
                         _tU32 u32PbarVal = FBHMI_WIDGET_DEF_PBARVAL,
                         _tU32 u32PbarMax = FBHMI_WIDGET_DEF_PBARMAX)
                         : fbhmi_Widget(u16Id,\
                         u32X, u32Y, u32Height, u32Width,\
                         u16BdrWidth, u32BgColor,\
                         u32FgColor, u32BdrColor,\
                         u32FillColor, sText,\
                         u8Align, bVisible,\
                         u32PbarVal, u32PbarMax)
{
    m_u16Id         = u16Id;
    m_u32x			= u32X;
    m_u32y          = u32Y;
    m_u32Height     = u32Height;
    m_u32Width      = u32Width;
    m_u16BdrWidth   = u16BdrWidth;
    m_u32BgColor    = u32BgColor;
    m_u32FgColor    = u32FgColor;
    m_u32BdrColor   = u32BdrColor;
    m_u32FillColor  = u32FillColor;
    m_strText       = sText;
    m_u8Align       = u8Align;
    m_bVisible      = bVisible;
    m_u32PbarVal    = u32PbarVal;
    m_u32PbarMax    = u32PbarMax;
    DEBUG_TRACE("%s", __func__);
}
/************************************************************************
* FUNCTION: fbhmi_Label::fbhmi_Label()
*
* DESCRIPTION: Parameterized Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Label::fbhmi_Label(fbhmi_Request *pReq)
{
    fbhmi_WidgetReq *pclWdgReq = dynamic_cast<fbhmi_WidgetReq*>(pReq);

    if(NULL != pReq && NULL != pclWdgReq)
    {
        m_u16Id			= pclWdgReq->m_u16WidgetID;
        m_u32x			= pclWdgReq->m_u32x;
        m_u32y			= pclWdgReq->m_u32y;
        m_u32Height		= pclWdgReq->m_u32height;
        m_u32Width		= pclWdgReq->m_u32width;
        m_u16BdrWidth	= pclWdgReq->m_u32borderWidth;
        m_u32BgColor	= pclWdgReq->m_u32bgColor;
        m_u32FgColor	= pclWdgReq->m_u32fgColor;
        m_u32BdrColor	= pclWdgReq->m_u32borderColor;
        m_u32FillColor	= pclWdgReq->m_u32fillColor;
        m_strText		= pclWdgReq->m_strText;
        m_u8Align		= pclWdgReq->m_u32textAlign;
        m_bVisible		= pclWdgReq->m_bvisibility;
        m_u32PbarVal	= pclWdgReq->m_u32value;
        m_u32PbarMax	= pclWdgReq->m_u32maxValue;
    }	

    m_pSurfaceHandle = fbhmi_Surface::pGetInstance();

    if(NULL == m_pSurfaceHandle)
    {
        DEBUG_TRACE("SurfacePointer is NULL");
    }
    DEBUG_TRACE("%s", __func__);

}

fbhmi_Label::~fbhmi_Label()
{
    DEBUG_TRACE("%s", __func__);
}

/************************************************************************
* FUNCTION: fbhmi_Label::vDrawWidget()
*
* DESCRIPTION: Draw a widget on to surface
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Label::vDrawWidget()
{
    if (NULL == m_pSurfaceHandle)
    {
        DEBUG_TRACE("Surface pointer is NULL");
        return;
    }

    if(m_u16BdrWidth > FBHMI_WIDGET_DEF_BWIDTH)
    {
        //Draw Border if present
        //m_pSurfaceHandle->vSetColor(m_u32BdrColor);
        m_pSurfaceHandle->vSetColor(m_u32BdrColor);
        m_pSurfaceHandle->vFillRectangle(m_u32x, m_u32y, m_u32Width, m_u32Height);
    }
    // Draw Background
    //m_pSurfaceHandle->vSetColor(m_u32BgColor);
    m_pSurfaceHandle->vSetColor(fbhmi_Color(m_u32BgColor));
    m_pSurfaceHandle->vFillRectangle(m_u32x+m_u16BdrWidth,
        m_u32y+m_u16BdrWidth,
        m_u32Width-m_u16BdrWidth*2,
        m_u32Height-m_u16BdrWidth*2);
    if(true == m_bVisible)
    {
        /*Fix for text clear issue If text size if more than label width
          clip the tail of string and append three dots*/
        _tU32 u32FontWidth = m_pSurfaceHandle->m_pFontHandle->u32GetFontWidth();
        _tU32 u32TmpTextWidth = (m_u32Width-m_u16BdrWidth*2)/u32FontWidth;

        if ( m_strText.size() >  u32TmpTextWidth)
        {
            m_strText.resize(u32TmpTextWidth-LABELTXT_TRAILING_DOT_SIZE);
            m_strText.append("...");
        }

        _tU32 au32Buff[(m_strText.size()+1) * sizeof(_tU32)];
        memset(au32Buff, 0, (m_strText.size()+1) * sizeof(_tU32));
        _tU32 u32AlignedX =0, u32AlignedY = 0;

        //Draw Text
        m_pSurfaceHandle->vSetColor(m_u32FgColor);      

        fbhmi_Utility::vConvlatin9toutf32(const_cast<_tChar*>(m_strText.c_str()), au32Buff, m_strText.size());
        vGetAlignedXY(&u32AlignedX, &u32AlignedY, m_strText.size());
        m_pSurfaceHandle->vDrawString(au32Buff, u32AlignedX, u32AlignedY);
        DEBUG_TRACE("Label Text: %s", m_strText.c_str());
    }

}
