/************************************************************************
* File: fbhmi_WidgetReq.cpp
* SW-Component: 
* Description: The class represents the widget properties common to all 
*              the widgets
* Author:
*   Rohit Channappiah Raman (RBEI/ECG4)
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 10.06.2013 - Initial version - Rohit Channappiah Raman (RBEI/ECG4)
***********************************************************************/
#include "fbhmi_WidgetReq.h"


fbhmi_WidgetReq::fbhmi_WidgetReq(_tU16 u16RequestID, \
                                 _tU16 u16ScreenID, \
                                 _tU16 u16WidgitID )\
                                 :fbhmi_Request(u16RequestID,\
                                 u16ScreenID,\
                                 u16WidgitID)
{
    m_u32x              = FBHMI_WIDGET_DEF_X;
    m_u32y              = FBHMI_WIDGET_DEF_Y;
    m_u32height         = FBHMI_WIDGET_DEF_HEIGHT;
    m_u32width          = FBHMI_WIDGET_DEF_WIDTH;
    m_u32borderWidth    = FBHMI_WIDGET_DEF_BWIDTH;
    m_u32bgColor        = FBHMI_WIDGET_DEF_BGCOLOR;
    m_u32fgColor        = FBHMI_WIDGET_DEF_FGCOLOR;
    m_u32borderColor    = FBHMI_WIDGET_DEF_BDRCOLOR;
    m_u32fillColor      = FBHMI_WIDGET_DEF_FILCOLOR;
    m_u32textAlign      = FBHMI_WIDGET_DEF_ALIGN;
    m_u32value          = FBHMI_WIDGET_DEF_PBARVAL;
    m_u32maxValue       = FBHMI_WIDGET_DEF_PBARMAX;
    m_bvisibility       = FBHMI_WIDGET_DEF_VISIBLE;

    strcpy( const_cast<_tChar*>(m_strText.c_str()),const_cast<_tChar*> (FBHMI_WIDGET_DEF_TEXT) );
	//DEBUG_TRACE("%s", __func__);
}

fbhmi_WidgetReq::~fbhmi_WidgetReq()
{
	DEBUG_TRACE("%s", __func__);
}

