/************************************************************************
* File: fbihmi_Request.cpp
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   This is a singleton class used to initialize and use the Linux
*   framebuffer for displaying characters. 
* Author:
*   Adityakumar.jha@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 07.06.2013 - Initial version - Adityakumar.jha@in.bosch.com
************************************************************************/

#include "fbhmi_Request.h"


/************************************************************************
* FUNCTION: fbhmi_Request::fbhmi_Request()
*
* DESCRIPTION: Default Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Request::fbhmi_Request()
{
	m_u16RequestID = FBHMI_EVNT_NONE;
	m_u16ScreenID = FBHMI_SCREEN_DEF_ID;
	m_u16WidgetID = FBHMI_SCREEN_DEF_ID;
	DEBUG_TRACE("%s", __func__);
}


/************************************************************************
* FUNCTION: fbhmi_Request::~fbhmi_Request()
*
* DESCRIPTION: Destructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Request::~fbhmi_Request()
{
	DEBUG_TRACE("%s", __func__);
}

/************************************************************************
* FUNCTION: fbhmi_Request::fbhmi_Request()
*
* DESCRIPTION: Parameterized constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Request::fbhmi_Request(_tU16 u16RequestId, _tU16 u16ScreenId, _tU16 u16WidgetId)
{
	m_u16RequestID = u16RequestId;
	m_u16ScreenID = u16ScreenId;
	m_u16WidgetID = u16WidgetId;
	DEBUG_TRACE("%s", __func__);
}



/************************************************************************
* FUNCTION: fbhmi_Request::u16GetRequestID()
*
* DESCRIPTION: 
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tU16 fbhmi_Request::u16GetRequestID()
{
	return m_u16RequestID;
}


/************************************************************************
* FUNCTION: fbhmi_Request::u16GetScreenID()
*
* DESCRIPTION: 
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tU16 fbhmi_Request::u16GetScreenID()
{
	return m_u16ScreenID;
}


/************************************************************************
* FUNCTION: fbhmi_Request::u16GetWidgetID()
*
* DESCRIPTION: 
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tU16 fbhmi_Request::u16GetWidgetID()
{
	return m_u16WidgetID;
}
