/************************************************************************
* File: fbhmi_Font.cpp
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   This is a singleton class used to initialize and use the Linux
*   framebuffer for displaying characters. 
* Author:
*   Adityakumar.jha@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 07.06.2013 - Initial version - Adityakumar.jha@in.bosch.com
* 13.06.2013 - Updated for first release - Gururaj.B@in.bosch.com
************************************************************************/
#include "fbhmi_Font.h"
#include "fbhmi_BDFFont.h"
#include <map>

#include "../fbhmi_Surface.h"
#include <stdio.h>

typedef map<string, fbhmi_Font *> fontMap;

static fontMap loadedFonts;

/************************************************************************
* FUNCTION: fbhmi_Font::fbhmi_Font()
*
* DESCRIPTION: Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Font::fbhmi_Font()
{
    m_s32PixelSize = 0;
	DEBUG_TRACE("%s", __func__);
};

/************************************************************************
* FUNCTION: fbhmi_Font::~fbhmi_Font()
*
* DESCRIPTION: Destructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Font::~fbhmi_Font()
{
	DEBUG_TRACE("%s", __func__);
};

/************************************************************************
* FUNCTION: fbhmi_Font::s32GetPixelSize()
*
* DESCRIPTION: Gets pixel size
*
* PARAMETER: None
*
* RETURNVALUE: int: pixel size
*************************************************************************/
_tS32 fbhmi_Font::s32GetPixelSize() 
{
	DEBUG_TRACE("%s", __func__);
	return m_s32PixelSize;
};

/************************************************************************
* FUNCTION: fbhmi_Font::vSetPixelSize()
*
* DESCRIPTION: Set pixel size
*
* PARAMETER: size
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Font::vSetPixelSize(_tS32 s32Size)
{
	DEBUG_TRACE("%s", __func__);
	m_s32PixelSize = s32Size;
};

/************************************************************************
* FUNCTION: fbhmi_Font::pclCreateFromFile()
*
* DESCRIPTION: creates font from file
*
* PARAMETER: string : fontFileName
*
* RETURNVALUE: fbhmi_Font *
*************************************************************************/
fbhmi_Font *fbhmi_Font::pclCreateFromFile(const string fontFileName)
{
	DEBUG_TRACE("%s", __func__);
	if (loadedFonts.find(fontFileName) != loadedFonts.end())
		return loadedFonts[fontFileName];

	if (fontFileName.rfind(".bdf") == (fontFileName.length() - 4))
	{
		fbhmi_BDFFont *pclFont = new fbhmi_BDFFont();
        if(pclFont == NULL) {
            DEBUG_TRACE("pclFont is NULL");
            return pclFont;
        }
		pclFont->vLoadBDF(fontFileName);
		pclFont->vExtractFontSize();
		loadedFonts[fontFileName] = pclFont;
		return pclFont;
	}	
	
	throw fbhmi_FontException("Unsupported font file");
};

/************************************************************************
* FUNCTION: fbhmi_Font::u32GetRealCharIndex()
*
* DESCRIPTION: 
*
* PARAMETER: uint32_t
*
* RETURNVALUE: uint32_t
*************************************************************************/
_tU32 fbhmi_Font::u32GetRealCharIndex(_tU32 u32Ch)
{
	DEBUG_TRACE("%s", __func__);
	if (!bIsCharDefined(u32Ch)) {
		if (bIsCharDefined(0xfffd))
			return 0xfffd;
		else
			return 0xffffffff;
	}
	else {
		return u32Ch;
	}
};

/************************************************************************
* FUNCTION: fbhmi_Font::vDrawBlock()
*
* DESCRIPTION: 
*
* PARAMETER: fbhmi_Surface *, posX, posY
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Font::vDrawBlock(fbhmi_Surface *graphics,_tU32 u32PosX, _tU32 u32PosY)
{
	_tS32 s32X, s32Y;
	DEBUG_TRACE("%s", __func__);

	if (graphics == NULL){
		DEBUG_TRACE("Surface pointer is NULL");
		return;
	}

	for (s32Y= 0; s32Y<m_s32PixelSize; s32Y++)
		for (s32X=0; s32X<(m_s32PixelSize/2); s32X++)
			fbhmi_Surface::pGetInstance()->vSetPixel(u32PosX + s32X, u32PosY - s32Y);
};


