/************************************************************************
* File: fbhmi_BDFFont.h
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   This is a singleton class used to initialize and use the Linux
*   framebuffer for displaying characters. 
* Author:
*   Adityakumar.jha@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 07.06.2013 - Initial version - Adityakumar.jha@in.bosch.com
* 13.06.2013 - Updated for first release - Gururaj.B@in.bosch.com
* 19.03.2014 - Added s32GetFontXPlus() and s32GetFontYPlus()- Aditya Kumar Jha
************************************************************************/
#ifndef _FBHMI_BDFFONT_H_
#define _FBHMI_BDFFONT_H_

#include "../fbhmi_Global.h"
#include <map>
#include <stdint.h>
#include "fbhmi_BDFFont.h"
#include "fbhmi_Font.h"

typedef std::map<_tU32, _tS64> mapping_t;

class fbhmi_BDFFont:public fbhmi_Font
{
public:
    fbhmi_BDFFont();
    virtual ~fbhmi_BDFFont();
    _tVoid vLoadBDF(const string sFontFileName);

    //virtual _tVoid v1DrawChar(_tU32 u32Ch, _tU32 u32X, _tU32 u32Y);
    virtual _tVoid vDrawChar(fbhmi_Surface *graphics, _tU32 ch, _tU32 x, _tU32 y);
    virtual _tBool bIsCharDefined(_tU32 u32Ch);

    virtual _tS32 s32GetAdvanceX(_tU32 u32Ch);
    virtual _tS32 s32GetAdvanceY(_tU32 u32Ch);

    _tVoid vExtractFontSize();
    _tU32 u32GetFontWidth();
    _tU32 u32GetFontHeight();
	 _tS32 s32GetFontXPlus();
	 _tS32 s32GetFontYPlus();
    virtual _tVoid vDrawBlock(fbhmi_Surface *graphics, _tU32 u32PosX, _tU32 u32PosY);

private:	
    _tVoid vGetSizeAndEncoding();
    _tVoid vLoadFontToMem(const string strFontFileName);
    _tVoid vFillMapping();

    _tVoid vDrawNotScaled(fbhmi_Surface *graphics,
        _tChar *pchFont,\
        _tU32 u32PosX,\
        _tU32 u32PosY,\
        _tS32 s32X_plus,\
        _tS32 s32Y_plus,\
        _tU32 u32Size_x,\
        _tU32 u32Size_y);

    _tChar *pGetMemory(_tChar *pchBuf, _tChar *pchFile, _tS32 s32Buff_size);
    _tChar *pGetSizePart(_tChar *pchBuf);

    _tS32 m_s32BdfPixelSize;

    mapping_t m_mapping;
    _tChar *m_pchMemory;

    _tU32 m_u32FontHeight;
    _tU32 m_u32FontWidth;
	 _tS32 m_s32FontsXPlus;
	 _tS32 m_s32FontsYPlus;
};

#endif //BDFFONT_H_



