#include "wdgHandler.h"
#include <string>
#include <signal.h>

#include "base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_PLATFORM
  #include "trcGenProj/Header/wdgHandler.cpp.trc.h"
#endif

namespace ai_sw_update {
namespace common {

void SigChldHandler(int Sig)
{
  return;
}

using namespace ::asf::core;

const std::string DEV_WDG("/dev/watchdog");


WDGControl::WDGControl() :
  _wdgTimer(),
  _wdgDevice()
{
  ETG_TRACE_USR4(("WDGControl: Ctor"));
  signal(SIGCHLD, SigChldHandler);
}


WDGControl::~WDGControl()
{
  ETG_TRACE_USR4(("WDGControl: Dtor"));
}


void WDGControl::onExpired(Timer& /*timer*/, boost::shared_ptr<TimerPayload> /*data*/)
{
  // Write arbritary data to watchdog device in order to cause a triggering.
  _wdgDevice << "0" << std::flush;

  if (!_wdgDevice.good()) {
    ETG_TRACE_ERR(("WDGControl: wdg device I/O error"));
    stopTriggering();
  }
}


void WDGControl::startTriggering(const uint32 inIntervalMS)
{
  _wdgDevice.open(DEV_WDG.c_str(), std::ios_base::out | std::ios_base::binary);

  if (_wdgDevice.is_open()) {
    _wdgTimer.start(*this, inIntervalMS, Timer::Periodic);
    ETG_TRACE_USR2 (("WDGControl: start triggering watchdog with %u ms", inIntervalMS));
  } else {
    ETG_TRACE_ERR (("WDGControl: error open %s", DEV_WDG.c_str()));
  }
}


void WDGControl::stopTriggering()
{
  _wdgTimer.stop();
  _wdgDevice.close();

  ETG_TRACE_USR2(("WDGControl: stop triggering watchdog"));
}

} // namespace ai_sw_update {
} // namespace common {
