#ifndef _WUP_Access_HPP_
#define _WUP_Access_HPP_


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


namespace ai_sw_update {
namespace common {


/**
 * Abstraction for accessing the OSAL Wakeup device.
 *
 * Example usage:
 * @code
 *    WUP_Access wupAccess;
 *    bool allOk=wupAccess.ioctl(OSAL_C_S32_IOCTRL_WUP_RESET_PROCESSOR, reinterpret_cast<intptr_t>(&rResetProcessorInfo));
 * @endcode
 */
class WUP_Access {
public:
   WUP_Access();
   ~WUP_Access();
   const bool isOpen() const;
   const bool open();
   void close();
   const bool ioctl(tS32 code, intptr_t options);  // use intptr_t for options since OSAL interface now uses intptr_t

private:
   OSAL_tIODescriptor _hDeviceWup;
};


} // namespace ai_sw_update {
} // namespace common {


#endif // _WUP_Access_HPP_
