#include "WUP_Access.hpp"


#include "base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_PLATFORM
  #include "trcGenProj/Header/WUP_Access.cpp.trc.h"
#endif


namespace ai_sw_update {
namespace common {


WUP_Access::WUP_Access()
  :_hDeviceWup(OSAL_ERROR)
{}

WUP_Access::~WUP_Access() {
  close();
}
const bool WUP_Access::isOpen() const {
  return (_hDeviceWup != OSAL_ERROR);
}
const bool WUP_Access::open() {
  ETG_TRACE_USR1(("WUP_Access.open START, isOpen()=%u", isOpen()));

  if (!isOpen()) {
     _hDeviceWup = OSAL_IOOpen (OSAL_C_STRING_DEVICE_WUP, OSAL_EN_READWRITE);
     if (!isOpen()) {
        ETG_TRACE_FATAL(("WUP_Access: could not open OSAL_C_STRING_DEVICE_WUP"));
     }
  }
  ETG_TRACE_USR1(("WUP_Access.open END isOpen()=%u", isOpen()));
  return isOpen();
}

void WUP_Access::close() {
  ETG_TRACE_USR1(("WUP_Access.close START, isOpen()=%u", isOpen()));
  if (isOpen()) {
     OSAL_s32IOClose(_hDeviceWup);
     _hDeviceWup=OSAL_ERROR;
  }

}

const bool WUP_Access::ioctl(tS32 code, intptr_t options) {   // use intptr_t for options since OSAL interface now uses intptr_t
  ETG_TRACE_USR1(("WUP_Access.ioctl : START isOpen=%u code=%d options=0x%u8x", isOpen(), code, options));
  if (!isOpen()) {
     open();
  }
  bool allOk=isOpen();
  if (!allOk) {
     ETG_TRACE_FATAL(("WUP_Access.ioctl : could not open DEV_WUP"));
  }

  if (allOk) {
     tS32 osalRes=OSAL_s32IOControl(_hDeviceWup, code, options);
     allOk=(OSAL_OK == osalRes);
     if (!allOk) {
        ETG_TRACE_FATAL(("WUP_Access.ioctl : OSAL_s32IOControl failed"));
     }

  }
  ETG_TRACE_USR1(("WUP_Access.ioctl : END allOk=%u", allOk));

  return allOk;
}


} // namespace ai_sw_update {
} // namespace common {
