///////////////////////////////////////////////////////////////////////////////
//
// File: swupd_fsmMCPUpd.cpp
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c swupd_fsmMcpUpd.fsm
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "ai_sw_update/common/base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_MCP
#define ETG_I_FILE_PREFIX 				mcp_fsmMCPUpdActions::
#include "trcGenProj/Header/swupd_fsmMCPUpd.cpp.trc.h"
#endif


#ifndef __INCLUDED_SWUPD_FSMMCPUPD__
#include "swupd_fsmMCPUpd.h"
#endif

namespace swupd_fsmMCPUpd
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataNotSentConfirmation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataSentConfirmation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDefaultSession ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDistribute ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvalNext ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvalTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNRC21Recieved ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadMCPSWVersion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );


protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! constructor for a substate of the given superstate
   FsmState ( FsmSuperState& parent );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! class constructor for a superstate without parent
   FsmSuperState ( FsmState& defState, bool histEnable=false );
   //! class constructor for a superstate with parent
   FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable=false );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class BusyState
   : public FsmSuperState
{
public:
   //! default constructor
   BusyState ( void );

   BusyState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* BusyState::mStateName = "Busy";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyWithUDSRequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class BusyWithUDSRequestState
   : public FsmSuperState
{
public:
   //! default constructor
   BusyWithUDSRequestState ( void );

   BusyWithUDSRequestState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* BusyWithUDSRequestState::mStateName = "BusyWithUDSRequest";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CompletePreDistributeObjectState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class CompletePreDistributeObjectState
   : public FsmState
{
public:
   //! default constructor
   CompletePreDistributeObjectState ( void );

   CompletePreDistributeObjectState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvalNext ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* CompletePreDistributeObjectState::mStateName = "CompletePreDistributeObject";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CriticalErrorDetectedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class CriticalErrorDetectedState
   : public FsmState
{
public:
   //! default constructor
   CriticalErrorDetectedState ( void );

   CriticalErrorDetectedState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* CriticalErrorDetectedState::mStateName = "CriticalErrorDetected";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DefaultSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DefaultSessionState
   : public FsmState
{
public:
   //! default constructor
   DefaultSessionState ( void );

   DefaultSessionState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DefaultSessionState::mStateName = "DefaultSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorDetectedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ErrorDetectedState
   : public FsmState
{
public:
   //! default constructor
   ErrorDetectedState ( void );

   ErrorDetectedState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ErrorDetectedState::mStateName = "ErrorDetected";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExtendedSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ExtendedSessionState
   : public FsmState
{
public:
   //! default constructor
   ExtendedSessionState ( void );

   ExtendedSessionState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ExtendedSessionState::mStateName = "ExtendedSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   IdleState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDefaultSession ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDistribute ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadMCPSWVersion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NRC27ReceivedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class NRC27ReceivedState
   : public FsmState
{
public:
   //! default constructor
   NRC27ReceivedState ( void );

   NRC27ReceivedState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNRC21Recieved ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* NRC27ReceivedState::mStateName = "NRC27Received";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PreDistributeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class PreDistributeState
   : public FsmSuperState
{
public:
   //! default constructor
   PreDistributeState ( void );

   PreDistributeState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* PreDistributeState::mStateName = "PreDistribute";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessPreDistributeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessPreDistributeState
   : public FsmState
{
public:
   //! default constructor
   ProcessPreDistributeState ( void );

   ProcessPreDistributeState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ProcessPreDistributeState::mStateName = "ProcessPreDistribute";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProgrammingSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProgrammingSessionState
   : public FsmState
{
public:
   //! default constructor
   ProgrammingSessionState ( void );

   ProgrammingSessionState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ProgrammingSessionState::mStateName = "ProgrammingSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadMCPSWVersionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ReadMCPSWVersionState
   : public FsmState
{
public:
   //! default constructor
   ReadMCPSWVersionState ( void );

   ReadMCPSWVersionState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ReadMCPSWVersionState::mStateName = "ReadMCPSWVersion";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestState
   : public FsmSuperState
{
public:
   //! default constructor
   RequestState ( void );

   RequestState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestState::mStateName = "Request";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadStartState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestDownloadStartState
   : public FsmState
{
public:
   //! default constructor
   RequestDownloadStartState ( void );

   RequestDownloadStartState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestDownloadStartState::mStateName = "RequestDownloadStart";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestEraseMemoryState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestEraseMemoryState
   : public FsmState
{
public:
   //! default constructor
   RequestEraseMemoryState ( void );

   RequestEraseMemoryState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestEraseMemoryState::mStateName = "RequestEraseMemory";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestKeyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestKeyState
   : public FsmState
{
public:
   //! default constructor
   RequestKeyState ( void );

   RequestKeyState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestKeyState::mStateName = "RequestKey";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestSeedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestSeedState
   : public FsmState
{
public:
   //! default constructor
   RequestSeedState ( void );

   RequestSeedState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestSeedState::mStateName = "RequestSeed";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendNewVersionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SendNewVersionState
   : public FsmState
{
public:
   //! default constructor
   SendNewVersionState ( void );

   SendNewVersionState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SendNewVersionState::mStateName = "SendNewVersion";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendRequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SendRequestState
   : public FsmState
{
public:
   //! default constructor
   SendRequestState ( void );

   SendRequestState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataNotSentConfirmation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataSentConfirmation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SendRequestState::mStateName = "SendRequest";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartPreDistributeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class StartPreDistributeState
   : public FsmState
{
public:
   //! default constructor
   StartPreDistributeState ( void );

   StartPreDistributeState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* StartPreDistributeState::mStateName = "StartPreDistribute";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StopMCPOnCriticalErrorState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class StopMCPOnCriticalErrorState
   : public FsmState
{
public:
   //! default constructor
   StopMCPOnCriticalErrorState ( void );

   StopMCPOnCriticalErrorState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* StopMCPOnCriticalErrorState::mStateName = "StopMCPOnCriticalError";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TimeoutHandlingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TimeoutHandlingState
   : public FsmState
{
public:
   //! default constructor
   TimeoutHandlingState ( void );

   TimeoutHandlingState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvalTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TimeoutHandlingState::mStateName = "TimeoutHandling";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   ToplevelState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UDSRequestFinishedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UDSRequestFinishedState
   : public FsmState
{
public:
   //! default constructor
   UDSRequestFinishedState ( void );

   UDSRequestFinishedState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UDSRequestFinishedState::mStateName = "UDSRequestFinished";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    BusyState oBusyState;
    BusyWithUDSRequestState oBusyWithUDSRequestState;
    CompletePreDistributeObjectState oCompletePreDistributeObjectState;
    CriticalErrorDetectedState oCriticalErrorDetectedState;
    DefaultSessionState oDefaultSessionState;
    ErrorDetectedState oErrorDetectedState;
    ExtendedSessionState oExtendedSessionState;
    IdleState oIdleState;
    NRC27ReceivedState oNRC27ReceivedState;
    PreDistributeState oPreDistributeState;
    ProcessPreDistributeState oProcessPreDistributeState;
    ProgrammingSessionState oProgrammingSessionState;
    ReadMCPSWVersionState oReadMCPSWVersionState;
    RequestState oRequestState;
    RequestDownloadStartState oRequestDownloadStartState;
    RequestEraseMemoryState oRequestEraseMemoryState;
    RequestKeyState oRequestKeyState;
    RequestSeedState oRequestSeedState;
    SendNewVersionState oSendNewVersionState;
    SendRequestState oSendRequestState;
    StartPreDistributeState oStartPreDistributeState;
    StopMCPOnCriticalErrorState oStopMCPOnCriticalErrorState;
    TimeoutHandlingState oTimeoutHandlingState;
    ToplevelState oToplevelState;
    UDSRequestFinishedState oUDSRequestFinishedState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evCriticalError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCriticalError *** 
}

void
FsmState::evDataNotSentConfirmation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataNotSentConfirmation *** 
}

void
FsmState::evDataSentConfirmation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataSentConfirmation *** 
}

void
FsmState::evDefaultSession ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDefaultSession *** 
}

void
FsmState::evDistribute ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDistribute *** 
}

void
FsmState::evEvalNext ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvalNext *** 
}

void
FsmState::evEvalTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvalTimeout *** 
}

void
FsmState::evEvaluation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvaluation *** 
}

void
FsmState::evGetError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evGetError *** 
}

void
FsmState::evGetResult ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evGetResult *** 
}

void
FsmState::evNRC21Recieved ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNRC21Recieved *** 
}

void
FsmState::evReadMCPSWVersion ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReadMCPSWVersion *** 
}

void
FsmState::evReadyToDo ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReadyToDo *** 
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

void
FsmState::evUDSRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUDSRequest *** 
}

void
FsmState::evUDSRequestFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUDSRequestFailed *** 
}

void
FsmState::evUDSRequestSuccess ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUDSRequestSuccess *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::FsmState ( FsmSuperState& parent )
   : mpParent(&parent)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( FsmState& defState, bool histEnable )
   : _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable )
   : FsmState(parent),
     _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

BusyState::BusyState ( void )
{}

BusyState::BusyState ( FsmBody& b )
   : FsmSuperState(b.oToplevelState, b.oDefaultSessionState, true)
{}

void
BusyState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oPreDistributeState.getStateName()) && (_history->getStateName() != b.oReadMCPSWVersionState.getStateName()) && (_history->getStateName() != b.oDefaultSessionState.getStateName()) && (_history->getStateName() != b.oExtendedSessionState.getStateName()) && (_history->getStateName() != b.oProgrammingSessionState.getStateName()) && (_history->getStateName() != b.oRequestSeedState.getStateName()) && (_history->getStateName() != b.oRequestKeyState.getStateName()) && (_history->getStateName() != b.oSendNewVersionState.getStateName()) && (_history->getStateName() != b.oRequestEraseMemoryState.getStateName()) && (_history->getStateName() != b.oRequestDownloadStartState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
BusyState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyWithUDSRequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

BusyWithUDSRequestState::BusyWithUDSRequestState ( void )
{}

BusyWithUDSRequestState::BusyWithUDSRequestState ( FsmBody& b )
   : FsmSuperState(b.oToplevelState, b.oSendRequestState, false)
{}

void
BusyWithUDSRequestState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:BusyWithUDSRequestState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
BusyWithUDSRequestState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:BusyWithUDSRequestState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
BusyWithUDSRequestState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:BusyWithUDSRequestState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
BusyWithUDSRequestState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:BusyWithUDSRequestState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CompletePreDistributeObjectState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

CompletePreDistributeObjectState::CompletePreDistributeObjectState ( void )
{}

CompletePreDistributeObjectState::CompletePreDistributeObjectState ( FsmBody& b )
   : FsmState(b.oPreDistributeState) 
{}

void
CompletePreDistributeObjectState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::entry"));
   s.actPrintCurrentState(pArg);
   s.actEvalPreDistributeStatus(pArg);
}

void
CompletePreDistributeObjectState::evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::evCriticalError"));
   // transition Actions
   s.actOnCriticalError(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStopMCPOnCriticalErrorState,pArg);
}

void
CompletePreDistributeObjectState::evEvalNext ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::evEvalNext"));
   if ( s.ifLastPreDistributeSuccess(pArg) )
   {
	    ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::ifLastPreDistributeSuccess success"));
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oStartPreDistributeState,pArg);
    }
    else
    {
		ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::ifLastPreDistributeSuccess is failed"));
		// set savepoint in superstate with enabled history
		b.oPreDistributeState.savepoint(b);

		// set savepoint in superstate with enabled history
		b.oBusyState.savepoint(b);

		// transition Actions
		s.actStopDistributeAndReturnError(pArg);
		b.setState(b.oIdleState,pArg);
    }
}

void
CompletePreDistributeObjectState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CompletePreDistributeObjectState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);

}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CriticalErrorDetectedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

CriticalErrorDetectedState::CriticalErrorDetectedState ( void )
{}

CriticalErrorDetectedState::CriticalErrorDetectedState ( FsmBody& b )
   : FsmState(b.oBusyWithUDSRequestState) 
{}

void
CriticalErrorDetectedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::entry"));
   s.actPrintCurrentState(pArg);
   s.actStopTimer(pArg);
}

void
CriticalErrorDetectedState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
CriticalErrorDetectedState::evGetError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::evGetError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evCriticalError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
CriticalErrorDetectedState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
CriticalErrorDetectedState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
CriticalErrorDetectedState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:CriticalErrorDetectedState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DefaultSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DefaultSessionState::DefaultSessionState ( void )
{}

DefaultSessionState::DefaultSessionState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
DefaultSessionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:DefaultSessionState::entry"));
   s.actPrintCurrentState(pArg);
}

void
DefaultSessionState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:DefaultSessionState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
DefaultSessionState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:DefaultSessionState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oExtendedSessionState,pArg);

}

void
DefaultSessionState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:DefaultSessionState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForDefaultSessionRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
DefaultSessionState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:DefaultSessionState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorDetectedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ErrorDetectedState::ErrorDetectedState ( void )
{}

ErrorDetectedState::ErrorDetectedState ( FsmBody& b )
   : FsmState(b.oBusyWithUDSRequestState) 
{}

void
ErrorDetectedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ErrorDetectedState::entry"));
   s.actPrintCurrentState(pArg);
   s.actStopTimer(pArg);
   s.actUDSRequestFailed(pArg);
}

void
ErrorDetectedState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ErrorDetectedState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
ErrorDetectedState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ErrorDetectedState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
ErrorDetectedState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ErrorDetectedState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
ErrorDetectedState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ErrorDetectedState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExtendedSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ExtendedSessionState::ExtendedSessionState ( void )
{}

ExtendedSessionState::ExtendedSessionState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
ExtendedSessionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ExtendedSessionState::entry"));
   s.actPrintCurrentState(pArg);
}

void
ExtendedSessionState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ExtendedSessionState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
ExtendedSessionState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ExtendedSessionState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oProgrammingSessionState,pArg);
}

void
ExtendedSessionState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ExtendedSessionState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForExtendedSessionRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ExtendedSessionState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ExtendedSessionState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

IdleState::IdleState ( FsmBody& b )
   : FsmState(b.oToplevelState) 
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:IdleState::entry"));
   s.actPrintCurrentState(pArg);
}

void
IdleState::evDefaultSession ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:IdleState::evDefaultSession"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oDefaultSessionState,pArg);
}

void
IdleState::evDistribute ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:IdleState::evDistribute"));
   // transition Actions
   s.actStoreDistribute(pArg);
   s.actPreparePreDistribute(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStartPreDistributeState,pArg);
}

void
IdleState::evReadMCPSWVersion ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:IdleState::evReadMCPSWVersion"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oReadMCPSWVersionState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NRC27ReceivedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

NRC27ReceivedState::NRC27ReceivedState ( void )
{}

NRC27ReceivedState::NRC27ReceivedState ( FsmBody& b )
   : FsmState(b.oRequestState) 
{}

void
NRC27ReceivedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::entry"));
   s.actPrintCurrentState(pArg);
   s.actRestartTimerLong(pArg);
   s.actDecNRC27Count(pArg);
}

void
NRC27ReceivedState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
NRC27ReceivedState::evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evEvaluation"));
   if ( s.ifNRC27Received(pArg) && s.ifNRC27CountNotZero(pArg) )
   {
	    ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::NRC21Recieved is received"));
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evNRC21Recieved; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oNRC27ReceivedState,pArg);
    } 
    else if ( s.ifResponseWasForLastRequest(pArg) )
   {
	    ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evEvaluation - ifResponseWasForLastRequest is true "));
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evUDSRequestSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oUDSRequestFinishedState,pArg);
    }
    else
    {
   // trigger events
		FsmEvent event = swupd_fsmMCPUpd::evUnknown;

		event = swupd_fsmMCPUpd::evUDSRequestFailed; //lint !e838 Info: Previously assigned value to variable has not been used
		(void) b.addEvent(event,pArg);
		b.setState(b.oErrorDetectedState,pArg);
    }
}

void
NRC27ReceivedState::evNRC21Recieved ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evNRC21Recieved"));
   if ( s.ifLessThanMaxNoOfTrials(pArg) && s.ifRetryRequired(pArg) )
   {
        // transition Actions
        s.actNRC27Received(pArg);
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
		ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evNRC21Recieved Requesting seed again"));
        b.setState(b.oRequestSeedState,pArg);
    }
}

void
NRC27ReceivedState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evResponseReceived"));
   // transition Actions
   s.actEvaluateRequestResponse(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvaluation; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
NRC27ReceivedState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
NRC27ReceivedState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
NRC27ReceivedState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:NRC27ReceivedState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PreDistributeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

PreDistributeState::PreDistributeState ( void )
{}

PreDistributeState::PreDistributeState ( FsmBody& b )
   : FsmSuperState(b.oBusyState, b.oStartPreDistributeState, true)
{}

void
PreDistributeState::savepoint ( FsmBody& b )
{
	ETG_TRACE_USR4(("MCPINFO:PreDistributeState::savepoint"));
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oStartPreDistributeState.getStateName()) && (_history->getStateName() != b.oProcessPreDistributeState.getStateName()) && (_history->getStateName() != b.oCompletePreDistributeObjectState.getStateName()) && (_history->getStateName() != b.oStopMCPOnCriticalErrorState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
PreDistributeState::evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:PreDistributeState::evCriticalError"));
   savepoint(b);
   // transition Actions
   s.actOnCriticalError(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStopMCPOnCriticalErrorState,pArg);
}

void
PreDistributeState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:PreDistributeState::evUDSRequest"));
   savepoint(b);
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessPreDistributeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessPreDistributeState::ProcessPreDistributeState ( void )
{}

ProcessPreDistributeState::ProcessPreDistributeState ( FsmBody& b )
   : FsmState(b.oPreDistributeState) 
{}

void
ProcessPreDistributeState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::entry"));
   s.actPrintCurrentState(pArg);
}

void
ProcessPreDistributeState::evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::evCriticalError"));
   // transition Actions
   s.actOnCriticalError(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStopMCPOnCriticalErrorState,pArg);
}

void
ProcessPreDistributeState::evGetError ( FsmBody& b, FsmBehaviour& s/* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::evGetError"));
   if ( s.IfUDSRequestFailed(pArg) )
   {
	    ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::evGetError UDSRequestFailed"));
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oStopMCPOnCriticalErrorState,pArg);
    }
}

void
ProcessPreDistributeState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalNext; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCompletePreDistributeObjectState,pArg);
}

void
ProcessPreDistributeState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
	ETG_TRACE_USR4(("MCPINFO:ProcessPreDistributeState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProgrammingSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProgrammingSessionState::ProgrammingSessionState ( void )
{}

ProgrammingSessionState::ProgrammingSessionState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
ProgrammingSessionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ProgrammingSessionState::entry"));
   s.actPrintCurrentState(pArg);
}

void
ProgrammingSessionState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ProgrammingSessionState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
ProgrammingSessionState::evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ProgrammingSessionState::evGetResult"));
   // transition Actions
   s.actWaitForJumpToBoot(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oRequestSeedState,pArg);
}

void
ProgrammingSessionState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ProgrammingSessionState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForProgrammingSessionRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ProgrammingSessionState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ProgrammingSessionState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadMCPSWVersionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ReadMCPSWVersionState::ReadMCPSWVersionState ( void )
{}

ReadMCPSWVersionState::ReadMCPSWVersionState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
ReadMCPSWVersionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ReadMCPSWVersionState::entry"));
   s.actPrintCurrentState(pArg);
}

void
ReadMCPSWVersionState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ReadMCPSWVersionState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
ReadMCPSWVersionState::evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ReadMCPSWVersionState::evGetResult"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   // transition Actions
   s.actCompleteReadMCPSWVersion(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ReadMCPSWVersionState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ReadMCPSWVersionState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForReadMCPSWVersion(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ReadMCPSWVersionState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:ReadMCPSWVersionState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestState::RequestState ( void )
{}

RequestState::RequestState ( FsmBody& b )
   : FsmSuperState(b.oBusyWithUDSRequestState, b.oSendRequestState, false)
{}

void
RequestState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
RequestState::evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evEvaluation"));
   if ( s.ifNRC27Received(pArg) && s.ifNRC27CountNotZero(pArg) )
   {
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evNRC21Recieved; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oNRC27ReceivedState,pArg);
    } 
    else if ( s.ifResponseWasForLastRequest(pArg) )
   {
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evUDSRequestSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oUDSRequestFinishedState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequestFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oErrorDetectedState,pArg);
    }
}

void
RequestState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evResponseReceived"));
   // transition Actions
   s.actEvaluateRequestResponse(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvaluation; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
RequestState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
RequestState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadStartState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestDownloadStartState::RequestDownloadStartState ( void )
{}

RequestDownloadStartState::RequestDownloadStartState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
RequestDownloadStartState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestDownloadStartState::entry"));
   s.actPrintCurrentState(pArg);
}

void
RequestDownloadStartState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestDownloadStartState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
RequestDownloadStartState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestDownloadStartState::evGetResult"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evDistribute; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oIdleState,pArg);
}

void
RequestDownloadStartState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestDownloadStartState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForRequestDownloadStartRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestDownloadStartState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestDownloadStartState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestEraseMemoryState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestEraseMemoryState::RequestEraseMemoryState ( void )
{}

RequestEraseMemoryState::RequestEraseMemoryState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
RequestEraseMemoryState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestEraseMemoryState::entry"));
   s.actPrintCurrentState(pArg);
}

void
RequestEraseMemoryState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestEraseMemoryState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
RequestEraseMemoryState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestEraseMemoryState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oRequestDownloadStartState,pArg);
}

void
RequestEraseMemoryState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestEraseMemoryState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForRequestEraseMemoryRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestEraseMemoryState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestEraseMemoryState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestKeyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestKeyState::RequestKeyState ( void )
{}

RequestKeyState::RequestKeyState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
RequestKeyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestKeyState::entry"));
   s.actPrintCurrentState(pArg);
}

void
RequestKeyState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestKeyState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
RequestKeyState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestKeyState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSendNewVersionState,pArg);
}

void
RequestKeyState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestKeyState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForRequestKeyRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestKeyState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestKeyState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestSeedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestSeedState::RequestSeedState ( void )
{}

RequestSeedState::RequestSeedState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
RequestSeedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestSeedState::entry"));
   s.actPrintCurrentState(pArg);
}

void
RequestSeedState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestSeedState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
RequestSeedState::evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestSeedState::evGetResult"));
   // transition Actions
   s.actStoreSeed(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oRequestKeyState,pArg);
}

void
RequestSeedState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestSeedState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForRequestSeedRequest(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestSeedState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:RequestSeedState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendNewVersionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SendNewVersionState::SendNewVersionState ( void )
{}

SendNewVersionState::SendNewVersionState ( FsmBody& b )
   : FsmState(b.oBusyState) 
{}

void
SendNewVersionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.actPrintCurrentState(pArg);
}

void
SendNewVersionState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendNewVersionState::evGetError"));
   if ( s.IfError(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        // transition Actions
        s.actExit(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
SendNewVersionState::evGetResult ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendNewVersionState::evGetResult"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evReadyToDo; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oRequestEraseMemoryState,pArg);
}

void
SendNewVersionState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendNewVersionState::evReadyToDo"));
   // transition Actions
   s.actFillBufferForSendNewVersion(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SendNewVersionState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendNewVersionState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendRequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SendRequestState::SendRequestState ( void )
{}

SendRequestState::SendRequestState ( FsmBody& b )
   : FsmState(b.oRequestState) 
{}

void
SendRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::entry"));
   s.actPrintCurrentState(pArg);
   s.actResetRetrycounter(pArg);
   s.actStartTimer(pArg);
   s.actSendRequest(pArg);
}

void
SendRequestState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
SendRequestState::evDataNotSentConfirmation ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evDataNotSentConfirmation"));
   if ( s.ifRetryCountNotExceeded(pArg) )
   {
        // transition Actions
        s.actStopTimer(pArg);
        s.actSendRequest(pArg);
        s.actStartTimer(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.actStopTimer(pArg);
   s.actStopUpdate(pArg);
   // this is an internal transition
    }
}

void
SendRequestState::evDataSentConfirmation ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evDataSentConfirmation"));
   // transition Actions
   s.actStopTimer(pArg);
   s.actStartTimer(pArg);
   // this is an internal transition
}

void
SendRequestState::evEvaluation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evEvaluation"));
   if ( s.ifNRC27Received(pArg) && s.ifNRC27CountNotZero(pArg) )
   {
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evNRC21Recieved; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oNRC27ReceivedState,pArg);
    } 
    else if ( s.ifResponseWasForLastRequest(pArg) )
   {
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evUDSRequestSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oUDSRequestFinishedState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequestFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oErrorDetectedState,pArg);
    }
}

void
SendRequestState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
	
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evResponseReceived"));
   // transition Actions
   s.actEvaluateRequestResponse(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvaluation; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SendRequestState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
SendRequestState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
SendRequestState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:SendRequestState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartPreDistributeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

StartPreDistributeState::StartPreDistributeState ( void )
{}

StartPreDistributeState::StartPreDistributeState ( FsmBody& b )
   : FsmState(b.oPreDistributeState) 
{}

void
StartPreDistributeState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StartPreDistributeState::entry"));
   s.actPrintCurrentState(pArg);
}

void
StartPreDistributeState::evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StartPreDistributeState::evCriticalError"));
   // transition Actions
   s.actOnCriticalError(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStopMCPOnCriticalErrorState,pArg);
}

void
StartPreDistributeState::evReadyToDo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StartPreDistributeState::evReadyToDo"));
   if ( s.ifFlashFileNotExists(pArg) )
   {
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oStopMCPOnCriticalErrorState,pArg);
    } 
    else if ( s.ifExistNextPreDistribute(pArg) )
   {
        // transition Actions
        s.actFillBufferForPreDistribute(pArg);
        // trigger events
        FsmEvent event = swupd_fsmMCPUpd::evUnknown;

        event = swupd_fsmMCPUpd::evUDSRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oProcessPreDistributeState,pArg);
    } 
    else if ( s.ifPreDistributeSuccess(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oPreDistributeState.savepoint(b);

        // set savepoint in superstate with enabled history
        b.oBusyState.savepoint(b);

        b.setState(b.oIdleState,pArg);
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   // transition Actions
   s.actHandlePreDistributeError(pArg);
   b.setState(b.oIdleState,pArg);
    }
}

void
StartPreDistributeState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StartPreDistributeState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StopMCPOnCriticalErrorState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

StopMCPOnCriticalErrorState::StopMCPOnCriticalErrorState ( void )
{}

StopMCPOnCriticalErrorState::StopMCPOnCriticalErrorState ( FsmBody& b )
   : FsmState(b.oPreDistributeState) 
{}

void
StopMCPOnCriticalErrorState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StopMCPOnCriticalErrorState::entry"));
   s.actPrintCurrentState(pArg);
}

void
StopMCPOnCriticalErrorState::evCriticalError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StopMCPOnCriticalErrorState::evCriticalError"));
   // transition Actions
   s.actOnCriticalError(pArg);
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oStopMCPOnCriticalErrorState,pArg);
}

void
StopMCPOnCriticalErrorState::evGetError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StopMCPOnCriticalErrorState::evGetError"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   // transition Actions
   s.actStopDistributeAndReturnError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
StopMCPOnCriticalErrorState::evGetResult ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StopMCPOnCriticalErrorState::evGetResult"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   // transition Actions
   s.actStopDistributeAndReturnError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
StopMCPOnCriticalErrorState::evUDSRequest ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:StopMCPOnCriticalErrorState::evUDSRequest"));
   // set savepoint in superstate with enabled history
   b.oPreDistributeState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oBusyState.savepoint(b);

   b.setState(b.oBusyWithUDSRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TimeoutHandlingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TimeoutHandlingState::TimeoutHandlingState ( void )
{}

TimeoutHandlingState::TimeoutHandlingState ( FsmBody& b )
   : FsmState(b.oBusyWithUDSRequestState) 
{}

void
TimeoutHandlingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::entry"));
   s.actPrintCurrentState(pArg);
   s.actEvaluateTimeout(pArg);
}

void
TimeoutHandlingState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
TimeoutHandlingState::evEvalTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::evEvalTimeout"));
   if ( s.ifLessThanMaxNoOfTimeout(pArg) && s.ifNotNRC27Received(pArg) )
   {
        b.setState(b.oSendRequestState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evUDSRequestFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oErrorDetectedState,pArg);
    }
}

void
TimeoutHandlingState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
TimeoutHandlingState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
TimeoutHandlingState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:TimeoutHandlingState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

ToplevelState::ToplevelState ( FsmBody& b )
   : FsmSuperState(b.oIdleState, false)
{}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UDSRequestFinishedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UDSRequestFinishedState::UDSRequestFinishedState ( void )
{}

UDSRequestFinishedState::UDSRequestFinishedState ( FsmBody& b )
   : FsmState(b.oBusyWithUDSRequestState) 
{}

void
UDSRequestFinishedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:UDSRequestFinishedState::entry"));
   s.actPrintCurrentState(pArg);
   s.actStopTimer(pArg);
}

void
UDSRequestFinishedState::evCriticalError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:UDSRequestFinishedState::evCriticalError"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oCriticalErrorDetectedState,pArg);
}

void
UDSRequestFinishedState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:UDSRequestFinishedState::evTimeout"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evEvalTimeout; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oTimeoutHandlingState,pArg);
}

void
UDSRequestFinishedState::evUDSRequestFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:UDSRequestFinishedState::evUDSRequestFailed"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

void
UDSRequestFinishedState::evUDSRequestSuccess ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   ETG_TRACE_USR4(("MCPINFO:UDSRequestFinishedState::evUDSRequestSuccess"));
   // trigger events
   FsmEvent event = swupd_fsmMCPUpd::evUnknown;

   event = swupd_fsmMCPUpd::evGetResult; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{
    mpBody = new FsmBody();
}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

void
Fsm::init ( void )
{
    
    if ( mpBody )
    {
        // connect the body with its frontend
        mpBody->connect(this);
        {
            mpBody->init();
        }
    }
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      oBusyState(*this),
      oBusyWithUDSRequestState(*this),
      oCompletePreDistributeObjectState(*this),
      oCriticalErrorDetectedState(*this),
      oDefaultSessionState(*this),
      oErrorDetectedState(*this),
      oExtendedSessionState(*this),
      oIdleState(*this),
      oNRC27ReceivedState(*this),
      oPreDistributeState(*this),
      oProcessPreDistributeState(*this),
      oProgrammingSessionState(*this),
      oReadMCPSWVersionState(*this),
      oRequestState(*this),
      oRequestDownloadStartState(*this),
      oRequestEraseMemoryState(*this),
      oRequestKeyState(*this),
      oRequestSeedState(*this),
      oSendNewVersionState(*this),
      oSendRequestState(*this),
      oStartPreDistributeState(*this),
      oStopMCPOnCriticalErrorState(*this),
      oTimeoutHandlingState(*this),
      oToplevelState(*this),
      oUDSRequestFinishedState(*this),
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

void
FsmBody::init ( void )
{
    oBusyState.reset();
    oBusyWithUDSRequestState.reset();
    oCompletePreDistributeObjectState.reset();
    oCriticalErrorDetectedState.reset();
    oDefaultSessionState.reset();
    oErrorDetectedState.reset();
    oExtendedSessionState.reset();
    oIdleState.reset();
    oNRC27ReceivedState.reset();
    oPreDistributeState.reset();
    oProcessPreDistributeState.reset();
    oProgrammingSessionState.reset();
    oReadMCPSWVersionState.reset();
    oRequestState.reset();
    oRequestDownloadStartState.reset();
    oRequestEraseMemoryState.reset();
    oRequestKeyState.reset();
    oRequestSeedState.reset();
    oSendNewVersionState.reset();
    oSendRequestState.reset();
    oStartPreDistributeState.reset();
    oStopMCPOnCriticalErrorState.reset();
    oTimeoutHandlingState.reset();
    oToplevelState.reset();
    oUDSRequestFinishedState.reset();

    setState(oToplevelState,0);
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evCriticalError:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evCriticalError called"));
            if ( mpState ) mpState->evCriticalError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataNotSentConfirmation:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evDataNotSentConfirmation called"));
            if ( mpState ) mpState->evDataNotSentConfirmation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataSentConfirmation:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evDataSentConfirmation called"));
            if ( mpState ) mpState->evDataSentConfirmation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDefaultSession:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evDefaultSession called"));
            if ( mpState ) mpState->evDefaultSession(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDistribute:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evDistribute called"));
            if ( mpState ) mpState->evDistribute(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvalNext:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evEvalNext called"));
            if ( mpState ) mpState->evEvalNext(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvalTimeout:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evEvalTimeout called"));
            if ( mpState ) mpState->evEvalTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvaluation:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evEvaluation called"));
            if ( mpState ) mpState->evEvaluation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evGetError:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evGetError called"));
            if ( mpState ) mpState->evGetError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evGetResult:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evGetResult called"));
            if ( mpState ) mpState->evGetResult(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNRC21Recieved:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evNRC21Recieved called"));
            if ( mpState ) mpState->evNRC21Recieved(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReadMCPSWVersion:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evReadMCPSWVersion called"));
            if ( mpState ) mpState->evReadMCPSWVersion(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReadyToDo:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evReadyToDo called"));
            if ( mpState ) mpState->evReadyToDo(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evResponseReceived called"));
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evTimeout called"));
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUDSRequest:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evUDSRequest called"));
            if ( mpState ) mpState->evUDSRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUDSRequestFailed:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evUDSRequestFailed called"));
            if ( mpState ) mpState->evUDSRequestFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUDSRequestSuccess:
		    ETG_TRACE_USR4(("FsmBody::acceptEvent evUDSRequestSuccess called"));
            if ( mpState ) mpState->evUDSRequestSuccess(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evCriticalError",
      "evDataNotSentConfirmation",
      "evDataSentConfirmation",
      "evDefaultSession",
      "evDistribute",
      "evEvalNext",
      "evEvalTimeout",
      "evEvaluation",
      "evGetError",
      "evGetResult",
      "evNRC21Recieved",
      "evReadMCPSWVersion",
      "evReadyToDo",
      "evResponseReceived",
      "evTimeout",
      "evUDSRequest",
      "evUDSRequestFailed",
      "evUDSRequestSuccess",
   };

   return eventNames[event];
}


} // namespace
