/************************************************************************
* File: mcp_Timer.cpp
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#include "mcp_fsmMCPUpdActions.h"
#include "mcp_Timer.h"

#include "ai_sw_update/common/base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_MCP
#define ETG_I_FILE_PREFIX 				mcp_Timer::
#include "trcGenProj/Header/mcp_Timer.cpp.trc.h"
#endif
/************************************************************************
 * FUNCTION: mcp_Timer()
 *
 * DESCRIPTION: Destructor
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
mcp_Timer::~mcp_Timer()
{
	ETG_TRACE_USR4(("mcp_Timer::mcp_Timer destructor called"));
	stopTimer();
	joinThread();
} 
/************************************************************************
 * FUNCTION: setDelay()
 *
 * DESCRIPTION: set the milli seconds to delay
 *
 * PARAMETER: None
 *
 * RETURNVALUE: bool
 *************************************************************************/
void mcp_Timer::setDelay(unsigned int milliseconds)
{
   m_milliseconds = milliseconds;
}
/************************************************************************
 * FUNCTION: startTimer()
 *
 * DESCRIPTION: start the timer
 *
 * PARAMETER: None
 *
 * RETURNVALUE: bool
 *************************************************************************/
auto mcp_Timer::startTimer() -> bool
{
	ETG_TRACE_USR4(("mcp_Timer::startTimer"));
	m_promise = std::promise<void>();
	joinThread(); // reset the promise before joining
	startThread();
	return true;
}
/************************************************************************
 * FUNCTION: stopTimer()
 *
 * DESCRIPTION: stops the timer
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_Timer::stopTimer()
{
  try {
    m_promise.set_value();
  } catch (...) {
    ETG_TRACE_USR4(("mcp_Timer:: timer already stopped"));
  }
}

/************************************************************************
 * FUNCTION: startThread()
 *
 * DESCRIPTION: starts the thread
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_Timer::startThread() {
  m_thread = std::thread(&mcp_Timer::threadFunc, this, m_promise.get_future());
  ETG_TRACE_USR4(("mcp_Timer:: mcp_Timer thread is created"));
}

/************************************************************************
 * FUNCTION: joinThread()
 *
 * DESCRIPTION: joins the thread
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_Timer::joinThread() {
  if (mcp_Timer::m_thread.joinable()) {
    mcp_Timer::m_thread.join();
    ETG_TRACE_USR4(("mcp_Timer:: mcp_Timer thread is joined"));
  }
}
/************************************************************************
 * FUNCTION: threadFunc()
 *
 * DESCRIPTION: executes the thread
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_Timer::threadFunc(std::future<void> fu) {
  if (!fu.valid()) {
    ETG_TRACE_USR4(("mcp_Timer:: timer already stopped, doing nothing"));
    return;
  }
  std::future_status status;
  status = fu.wait_for(std::chrono::milliseconds(m_milliseconds));
  if (status == std::future_status::timeout) {
    ETG_TRACE_USR4(("mcp_Timer:: mcp_Timer thread has exceeded update time"));
    raiseEventTimeout();
  } else if (status == std::future_status::ready) {
    ETG_TRACE_USR4(("mcp_Timer:: mcp_Timer future is ready"));
  }
  ETG_TRACE_USR4(("mcp_Timer:: mcp_Timer thread finished"));
}

/************************************************************************
 * FUNCTION: raiseEventTimeout()
 *
 * DESCRIPTION: raise Event Timeout
 *
 * PARAMETER: bool
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_Timer::raiseEventTimeout()
{
		
      ETG_TRACE_USR4(("mcp_Timer::Raised timeout event"));
      mcp_Request msg(swupd_fsmMCPUpd::evTimeout);
      mcp_ClientHandler::pclGetQueueHandle()->bPushQueue(msg);;
}
