/************************************************************************
* File: mcp_SecurityAlgorithm.cpp
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   Surparaju.Pavankumar@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#include "mcp_SecurityAlgorithm.h"

bool GenerateKeyExOpt(
const unsigned char* ipSeedArray,          /* Array for the seed [in] */
unsigned int iSeedArraySize,               /* Length of the array for the seed [in] */
unsigned char* iopKeyArray,                /* Array for the key [in, out] */
unsigned int iMaxKeyArraySize,             /* Maximum length of the array for the key [in] */
unsigned int& oActualKeyArraySize) 
{

    bool res = true;
    const unsigned char keybuf[16] = {0x35, 0xF1, 0x16, 0xF8, 0xCF, 0x69, 0x65, 0xA9, 0xB3, 0xB2, 0xD8, 0x22, 0x46, 0x82, 0x28, 0xE4};
   
    unsigned char TempSeed[SEED_SIZE];
    unsigned char TempKey[KEY_SIZE];

    for(int i=0; i<SEED_SIZE; i++)
    {
        TempSeed[i] = ipSeedArray[i];
    }
    // To fix CID 3198232
    AES_KEY AESkey={};
    AES_set_decrypt_key((const unsigned char *) keybuf, 128, &AESkey);
    AES_ecb_encrypt(TempSeed, TempKey, &AESkey, AES_ENCRYPT);
    AES_ecb_encrypt(TempKey, (unsigned char *)(&TempKey[16]), &AESkey, AES_ENCRYPT);

    for(int i=0; i<KEY_SIZE; i++)
    {
        iopKeyArray[i] = TempKey[i];
    }
	
    oActualKeyArraySize = KEY_SIZE;
   
    return res;
}
