/************************************************************************
* File: mcp_Request.h
* SW-Component: 
* Description: 
*   
* Author:
*	Surparaju.Pavankumar@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 28.04.2020 - Initial version - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_REQUEST_H_
#define _MCP_REQUEST_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "swupd_fsmMCPUpd.h"
#include <vector>

class mcp_Request
{

public:
         
    mcp_Request(swupd_fsmMCPUpd::FsmEvent dataEvent, std::vector<tU8>& data, tU16 dataLength):
       _event(dataEvent),
      _data(data),
      _dataLength(dataLength)
      {
      }
         
    mcp_Request(swupd_fsmMCPUpd::FsmEvent dataEvent) :
       _event(dataEvent),
      _dataLength(0)
      {
          
      }
    virtual ~mcp_Request() { }
        
    swupd_fsmMCPUpd::FsmEvent getEvent()
    {
        return _event;
    }
    
    tU16 getDataLength()
    {
        return _dataLength;
    }
    
    std::vector<tU8>& getData()
    {
       return _data;
    }        

    private:
    std::vector<tU8> _data;
    tU16 _dataLength;
    swupd_fsmMCPUpd::FsmEvent _event;    
};

#endif 
