/************************************************************************
 * File: mcp_FileHandler.cpp
 * SW-Component:
 *
 * Description:
 *	Calls APIs of MCP library and handles the responses
 *
 * Author:
 *   RamaGopalReddy.Bommireddy@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
 * 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
 ***********************************************************************/

using namespace std;

#include "mcp_FileHandler.h"




#include "ai_sw_update/common/base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_MCP
#define ETG_I_FILE_PREFIX 				mcp_FileHandler::
#include "trcGenProj/Header/mcp_FileHandler.cpp.trc.h"
#endif

#ifndef __SW_UPDATE_UNIT_TESTING__
// Implementation of the methods getInstanceOfmcp_FileHandler and releaseInstanceOfmcp_FileHandler
// In case of __SW_UPDATE_UNIT_TESTING__ they are implemented in mock!
SWU_IMPL_GET_AND_RELEASE_INSTANCE(mcp_FileHandler);
#endif

// Implementation of the singleton methods
SWU_IMPL_SINGLETON(mcp_FileHandler);

/************************************************************************
 * FUNCTION: mcp_FileHandler()
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
mcp_FileHandler::mcp_FileHandler() : maxIterations(0), currentIteration(0),filepath("")                       
{
  
}

/************************************************************************
 * FUNCTION: ~mcp_FileHandler
 * DESCRIPTION: Destruction
 * PARAMETER: None
 * RETURNVALUE: None
 *************************************************************************/
mcp_FileHandler::~mcp_FileHandler()
{ 

}

/************************************************************************
 * FUNCTION: getcurrentIteration()
 *
 * DESCRIPTION: Get the current Iteration of the binary file
 *
 * PARAMETER: None
 *
 * RETURNVALUE: unsigned int
 *************************************************************************/
unsigned int mcp_FileHandler::getcurrentIteration()
{
	ETG_TRACE_USR4(("mcp_FileHandler::currentIteration : %u", currentIteration));
	return currentIteration;
}

/************************************************************************
 * FUNCTION: getMaxIteration()
 *
 * DESCRIPTION: Get the max number iterations operates on binary file
 *
 * PARAMETER: None
 *
 * RETURNVALUE: unsigned int
 *************************************************************************/
unsigned int mcp_FileHandler::getMaxIteration()
{
	ETG_TRACE_USR4(("mcp_FileHandler::maxIterations : %u", maxIterations));
	return maxIterations;
}

/************************************************************************
 * FUNCTION: IncrcurrentIteration()
 *
 * DESCRIPTION: Increments the current iteration
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void  mcp_FileHandler::IncrcurrentIteration()
{
	currentIteration =  currentIteration + 1;
	ETG_TRACE_USR4(("mcp_FileHandler::IncrcurrentIteration : %u", currentIteration));
}

/************************************************************************
 * FUNCTION: ReadBuffer()
 *
 * DESCRIPTION: Reading the file buffer . 
 *              Return true if file exists. Flase if file not exists
 *
 * PARAMETER: std::vector<unsigned char>&, unsigned long int, unsigned int
 *
 * RETURNVALUE: bool
 *************************************************************************/

bool mcp_FileHandler::ReadBuffer(std::vector<unsigned char>& data, unsigned long int seek, unsigned int &bytesread)
{	
	std::ifstream file;
	file.open(filepath.c_str(), std::ios::binary);
	if ( !file ) {
		ETG_TRACE_USR4(("mcp_FileHandler::ReadBuffer File is empty"));
		return false;
	}
	
	data.resize(static_cast<size_t> (MAX_BUFFER_SIZE));
	ETG_TRACE_USR4(("mcp_FileHandler::ReadBuffer seek = %lu",seek));
	file.seekg(seek, file.beg);
	file.read(reinterpret_cast<char *>(&data[0]), MAX_BUFFER_SIZE); 
	bytesread = file.gcount(); 
	file.close();
	return true;
}

/************************************************************************
 * FUNCTION: CalculateMaxIterations()
 *
 * DESCRIPTION: Calculates max number of iterations and 
 *              return true if file containes data.
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
bool mcp_FileHandler::CalculateMaxIterations()
{
   struct stat statbuf;
   if (::stat(filepath.c_str(), &statbuf) == -1) {
      return false;
   }
   if (statbuf.st_size == 0)
	return false;
   
   maxIterations = static_cast<unsigned int>(statbuf.st_size/MAX_BUFFER_SIZE);
   
   if(!(statbuf.st_size)%(MAX_BUFFER_SIZE) == 0)
   {
	maxIterations = maxIterations + 1;
   }   
   ETG_TRACE_USR4(("mcp_FileHandler::maxIterations = %u",maxIterations));
   return true;
}

/************************************************************************
 * FUNCTION: setFilePath()
 *
 * DESCRIPTION: Set the file path
 *
 * PARAMETER: std::string
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_FileHandler::setFilePath(std::string path)
{
	 ETG_TRACE_USR4(("mcp_FileHandler::setFilePath = %s",path.c_str()));
	 filepath = path;
}

/************************************************************************
 * FUNCTION: isLastIteration()
 *
 * DESCRIPTION: Checks the current iteratios in last iteration
 *				Return true if current iteration is equals to max ietarion
 *              otherwise false. 
 * PARAMETER: None
 *
 * RETURNVALUE: bool
 *************************************************************************/
bool mcp_FileHandler::isLastIteration()
{
    if(currentIteration == maxIterations )
	{
		ETG_TRACE_USR4(("mcp_FileHandler::isLastIteration is true"));
        	return true;
	}
    else
        return false;
}

/************************************************************************
 * FUNCTION: ifFileExists()
 *
 * DESCRIPTION: Check the file is exists
 *
 * PARAMETER: None
 *
 * RETURNVALUE: bool
 *************************************************************************/
bool mcp_FileHandler::ifFileExists()
{
   struct stat statbuf;
   if (::stat(filepath.c_str(), &statbuf) == -1) {
	ETG_TRACE_USR4(("mcp_FileHandler::File is not exists"));
      	return false;
   }
   else
   {
	ETG_TRACE_USR4(("mcp_FileHandler::File is exists"));
	return true;
   }
}

/************************************************************************
 * FUNCTION: calculateFileSize()
 *
 * DESCRIPTION: calculates the file size
 *
 * PARAMETER: None
 *
 * RETURNVALUE: unsigned int
 *************************************************************************/
unsigned int mcp_FileHandler::calculateFileSize()
{
   struct stat statbuf;
   unsigned int fileSize = 0;
   if (::stat(filepath.c_str(), &statbuf) == -1) {
	ETG_TRACE_USR4(("mcp_FileHandler::File not exists"));
	return fileSize;
   }
   fileSize = static_cast<unsigned int>(statbuf.st_size);
   ETG_TRACE_USR4(("mcp_FileHandler::Filesize = %u",fileSize));
   return fileSize;
}
