/************************************************************************
* File: mcp_CsmProxy.h
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_CSMPROXY_H_
#define _MCP_CSMPROXY_H_

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <istream>
#include <iterator>
#include <algorithm>
#include <thread>
#include "mcp_Request.h"

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"

#include "modules_swa/csm_stack/src/csm_stack_ip_inf4cv.h"

#define MCP_CSM_CALLBACK                                // replaces CSM_CALLBACK
#define MCP_SUCCESS                                         ((tU32) 0x00000000)

#define MCP_RX_BUFFER_SIZE                              256
#define MCP_TX_BUFFER_SIZE                              256

#define MAX_QUEUE_ELEMENTS                              100

using namespace std;
class mcp_fsmMCPUpdActions;

class mcp_CsmProxy
{

public:
    mcp_CsmProxy();
   ~mcp_CsmProxy();   
   
   void vInit();
   void vDeInit();
   
   tVoid mcp_vRegisterCsmCallbacks ( tVoid );
   tVoid mcp_vUnregisterCsmCallbacks ( tVoid );
   tS32 sendUdsDataMessage(tPCU8 mcp_pcu8TxBuffer,tU16 mcp_u16TxBufferLen,tU32 pcvAddressField=CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_MCAN_CDIAG);

   // Call back functions are declared.

   static tVoid mcp_vCSMDataConfirmation(tVoid* handle, tU32 protocol, const tVoid* addrField, tU8 transResult);
   static tVoid mcp_vCSMDataIndication(tVoid* handle, tU32 protocol, const tVoid* addrField, tU8* pData, tU16 u16DataLength);
   
protected:
   csm_tclCsmAccessUser* _pCsmAccessUser;

private:
   tS32  mcp_vRegisterApplCallbackInit();
   void mcp_vSetAddressField(BYTE* addrField);

};

#endif //_mcp_CsmProxy_H_
