#ifndef SWU_LCM_COMPONENT_H_
#define SWU_LCM_COMPONENT_H_

#define SWULCM_NS_LCM_BASE_APP ::org::bosch::cm::lcm::lcmbaseappcomponent
#define SWULCM_NS_NSM_ERROR_TYPES ::org::genivi::NodeStateManager::LcmErrorTypes
#define SWULCM_NS_NSM_BASIC_TYPES ::org::genivi::NodeStateManager::LcmBasicTypes

#include "asf/core/ApplicationIF.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"

#include "base/imp/swupd_trace.h"

namespace ai_sw_update {
namespace common {
namespace lcm {
namespace imp {

class SwuLcmComponent
   : public ::asf::core::BaseComponent,
     public ::asf::core::TimerCallbackIF,
     public SWULCM_NS_LCM_BASE_APP::LcmApplicationControlIF
{
public:
   SwuLcmComponent();
   
   // LcmBaseComponent
   virtual SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e OnAppModeChange(SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e newAppMode, SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e oldAppMode);
   virtual bool   OnAppWatchdog();
   virtual void   OnLcmRegistered();


   virtual void onExpired(::asf::core::Timer& timer, boost::shared_ptr< ::asf::core::TimerPayload > data);
private:

   bool isFile(std::string filename);
   bool isDirectory(std::string dirname);
   bool createDirectory(std::string dirname);


   bool touchFile(const std::string& filename);
   bool removeFile(const std::string& filename);


   SWULCM_NS_LCM_BASE_APP::LcmBaseAppComponent _lcmAppComponent;
   ::asf::core::Timer _pollTimer; //!< ASF timer
   bool _firstStart;
   DECLARE_CLASS_LOGGER ();

};


} // namespace imp
} // namespace lcm
} // namespace common
} // namespace ai_sw_update


#endif // SWU_LCM_COMPONENT_H_
