#include <cstdlib>

#include <fcntl.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <iostream>
#include <fstream>
#include <sys/stat.h>

#include "SwuLcmComponent.h"
#ifndef __SW_UPDATE_UNIT_TESTING__
#include <systemd/sd-daemon.h>
#endif

#include "base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_LCM
#include "trcGenProj/Header/SwuLcmComponent.cpp.trc.h"
#endif

namespace ai_sw_update {
namespace common {
namespace lcm {
namespace imp {

static const std::string _startupMarkerFileDir="/tmp/swupd";
static const std::string _startupMarkerFileName="SwuStarting";
static const unsigned int _pollIntervalMs=1000;
static const  unsigned int _maxNumPolls=10;
DEFINE_CLASS_LOGGER_AND_LEVEL("swupdate/lcm", SwuLcmComponent, Info);

SwuLcmComponent::SwuLcmComponent() :
   ::asf::core::BaseComponent(),
   _lcmAppComponent(/*busname*/ "ai_sw_update.common.lcm.imp.SwuLcmApplication",
                    /*busname == <package name as set in your cma file>.<application name>*/
                    /*objname*/ "/org/genivi/NodeStateManager/LifeCycleConsumer/SwuLcmApplication",
                    /*objname == <object name given in your cma file at exportByName for the LifeCycleConsumerPort */
                    *this),
   _firstStart(true) {
   // App-level: open Trace for asf-app
   vInitPlatformEtg();
   printf("SwuLcmComponent: Ctor\n");
   ETG_TRACE_USR2(("SwuLcmComponent: Ctor"));
   _lcmAppComponent.setAppStartReady();
#ifndef __SW_UPDATE_UNIT_TESTING__
   sd_notify(0, "READY=1");
#endif
}


SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e SwuLcmComponent::OnAppModeChange(SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e newAppMode, SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e oldAppMode){
   SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e returnVal = SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
   LOG_INFO("OnAppModeChange - %i", newAppMode);
   ETG_TRACE_USR2(("SwuLcmComponent: OnAppModeChange"));
   printf("SwuLcmComponent: OnAppModeChange\n");
   std::string markerFilePathAndName=_startupMarkerFileDir + "/" + _startupMarkerFileName;
   if(newAppMode == SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Runup)
   {
   ETG_TRACE_USR2(("SwuLcmComponent: OnAppModeChange:Normal _firstStart=%u\n,", _firstStart));
      if (_firstStart) {
         _firstStart=false;
         createDirectory(_startupMarkerFileDir);
         touchFile(markerFilePathAndName);
      }
      // goto Normal Mode
      returnVal = SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e__NsmErrorStatus_Ok; // if successfull
   }
   else if(newAppMode == SWULCM_NS_NSM_BASIC_TYPES::_Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Normal)
   {
      ETG_TRACE_USR2(("SwuLcmComponent: OnAppModeChange:Off"));
      printf("SwuLcmComponent: OnAppModeChange:Off\n");
      for (unsigned int numPolls=0; numPolls<_maxNumPolls; ++numPolls) {
         if (isFile(markerFilePathAndName)) {
            ETG_TRACE_USR2(("SwuLcmComponent: OnAppModeChange:Off: waiting"));
            usleep(_pollIntervalMs);
            continue;
         }
      }

      // goto OFF Mode
      returnVal = SWULCM_NS_NSM_ERROR_TYPES::_NsmErrorStatus_e__NsmErrorStatus_Ok; // if successfull
   }

   return returnVal;
  
};
bool   SwuLcmComponent::OnAppWatchdog(){
   return true;
};
void   SwuLcmComponent::OnLcmRegistered(){};


void SwuLcmComponent::onExpired(::asf::core::Timer& timer, boost::shared_ptr< ::asf::core::TimerPayload > data){

}

bool SwuLcmComponent::isFile(std::string filename) {
   struct stat file_stat;
   memset(&file_stat, 0, sizeof(file_stat));
   if (stat(filename.c_str(), &file_stat)) {
      ETG_TRACE_ERR(("isFile:Unable to get stat of (errno %8d)%s ", errno, filename.c_str()));
      return false;
   }
   return S_ISREG(file_stat.st_mode);

}

bool SwuLcmComponent::isDirectory(std::string dirname) {
   struct stat dir_stat;
   memset(&dir_stat, 0, sizeof(dir_stat));
   if (stat(dirname.c_str(), &dir_stat)) {
      ETG_TRACE_ERR(("isDirectory:Unable to get stat of (errno %8d) %s, ", errno, dirname.c_str()));
      return false;
   }
   return S_ISDIR(dir_stat.st_mode);
}

bool SwuLcmComponent::createDirectory(std::string dirname) {
   if (isDirectory(dirname)) {
      return true;
   }

   if (mkdir(dirname.c_str(), 0700) != 0) {
      ETG_TRACE_FATAL(("Error creating directory (errno %8d) %s", errno, dirname.c_str()));
      return false;
   }
   return true;
}


bool SwuLcmComponent::touchFile(const std::string& filename)
{
   int fd = open(filename.c_str(),
                 O_WRONLY|O_CREAT|O_NOCTTY|O_NONBLOCK,
                 0600);
   if (fd<0) // Couldn't open that path.
   {
      ETG_TRACE_FATAL(("Unable to touch (open, errno %8d) %s ", errno, filename.c_str()));
      return false;
   }
   close(fd);
   return true;
}

bool SwuLcmComponent::removeFile(const std::string& filename)
{
   
   if (!isFile(filename)) {
      return true;
   }
   if (unlink(filename.c_str())<0) // Couldn't open that path.
   {
      ETG_TRACE_FATAL(("Unable to removeFile (unlink, errno %8d) %s ", errno, filename.c_str()));
      return false;
   }
   return true;
}

} // namespace imp
} // namespace lcm
} // namespace common
} // namespace ai_sw_update
