
/************************************************************************
*FILE					: swuhmi_window.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Base Window Class.
*DESCRIPTION			: It provides the base for all project specific windows.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#include <string>
#include <time.h>
#include "swuhmi_window.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_WINDOW_"
#define ETG_I_FILE_PREFIX 				SWUHMI::window::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_window.cpp.trc.h"
#endif

namespace swuhmi {

/************************************************************************
*FUNCTION			: window
*DESCRIPTION		: Constructor of window class
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
window::window()
{
	ETG_TRACE_USR2(("Constructor"));

	m_u8Opacity				= 0;
	m_u32ActualWndWidth 	= 0;
	m_u32ActualWndHeight	= 0;

}

/************************************************************************
*FUNCTION			: window
*DESCRIPTION		: Destructor of window class
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
window::~window()
{
	// TODO Auto-generated destructor stub
}

/************************************************************************
*FUNCTION			: GetScreenResolution
*DESCRIPTION		: Get the Screen Resolution From Render Class
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::GetScreenResolution()
{
	ETG_TRACE_USR2(("GetScreenResolution"));

	if(m_u32ActualWndWidth == 0 || m_u32ActualWndHeight == 0)
	{
		m_u32ActualWndWidth	 = graphicsinterface::GetActualWidth();
		m_u32ActualWndHeight = graphicsinterface::GetActualHeight();
		ETG_TRACE_USR2(("Screen Width:%u, Height:%u", m_u32ActualWndWidth, m_u32ActualWndHeight));
	}
}

/************************************************************************
*FUNCTION			: SetBackGroundImage
*DESCRIPTION		: Set the Back Ground Image- Logo
*PARAMETER			: string (I)
*PARAMETER				Image Name with Path.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::SetBackGroundImage(string strPath,float xPos,float yPos)
{
	ETG_TRACE_USR4(("SetBackGroundImage"));
	graphicsinterface::SetBackGndImage(strPath,xPos,yPos);
}

/************************************************************************
*FUNCTION			: ShowProgressBar
*DESCRIPTION		: Show the Progress Bar
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::ShowProgressBar()
{
	ETG_TRACE_USR4(("ShowProgressBar"));
}

/************************************************************************
*FUNCTION			: ShowWindow
*DESCRIPTION		: Call to render class to draw window.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::ShowWindow()
{
	ETG_TRACE_USR4(("ShowWindow"));
	graphicsinterface::ShowWindow();
}

/************************************************************************
*FUNCTION			: CloseWindow
*DESCRIPTION		: Call to render class to clear window.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::CloseWindow()
{
	StopRemainingTimeTimer();
	ETG_TRACE_USR4(("ShowWindow"));
	graphicsinterface::CloseWindow();
}

/************************************************************************
*FUNCTION			: StartRemainingTimeTimer
*DESCRIPTION		: To Start the Remaining Time Timer.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::StartRemainingTimeTimer()
{
	ETG_TRACE_USR2(("StartRemainingTimeTimer"));
	m_RemainingTimeTimer.start(this, REMAINING_TIME_FOR_UPDATE_IN_MS);
}


/************************************************************************
*FUNCTION			: vProcess
*DESCRIPTION		: On Elapse of Remaining Timer.
*PARAMETER			: Msg_RemainingTimeTimer (I)
*PARAMETER				Contains the Info.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::vProcess(Msg_RemainingTimeTimer *pMsg)
{
	(void)pMsg;
	OnRemainingTimeExpiry();
	//m_RemainingTimeTimer.start(this, REMAINING_TIME_FOR_UPDATE_IN_MS);
}

tBool window::IsRemainingTimeTimerRunning() {
	if(m_RemainingTimeTimer.isRunning())
		return true;
	else
		return false;
}

/************************************************************************
*FUNCTION			: StopRemainingTimeTimer
*DESCRIPTION		: Stop the Running Remaining Timer.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid window::StopRemainingTimeTimer()
{
	ETG_TRACE_USR2(("StopRemainingTimeTimer"));
	if(m_RemainingTimeTimer.isRunning())
		m_RemainingTimeTimer.stop();
}

}




