
/************************************************************************
*FILE					: swuhmi_line.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Line Class.
*DESCRIPTION			: Which Implements the Drawing of Line & ProgressBar.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#include "swuhmi_line.h"
#include "swuhmi_graphicsinterface.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_LABEL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_line.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION			: line
*DESCRIPTION		: Constructor of line class
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
line::line()
{
	// TODO Auto-generated constructor stub
	m_u16LineWidth 				= 0;
	m_16ProgressValue 			= 0;
	m_u16ProgressFillValue		= 0;
	m_u32DefaultProgressColor	= 0;
	m_u32CompletePercentColor 	= 0;
	m_u16FontHeight				= 0;

}

/************************************************************************
*FUNCTION			: line
*DESCRIPTION		: Destructor of line class
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
line::~line()
{
	// TODO Auto-generated destructor stub
}

/************************************************************************
*FUNCTION			: SetLineWidth
*DESCRIPTION		: To Set Line Width.
*PARAMETER			: tU16 (I)
*PARAMETER				Width.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::SetLineWidth(tU16 u16Width)
{
	m_u16LineWidth = u16Width;
}

/************************************************************************
*FUNCTION			: SetProgressValue
*DESCRIPTION		: To Set Progress Value.
*PARAMETER			: tU16 (I)
*PARAMETER				Progress Value.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::SetProgressValue(tU16 u16ProgressValue)
{
	m_16ProgressValue = u16ProgressValue;
}

tVoid line::SetProgressFillValue(tU16 u16ProgressFillValue)
{
	m_u16ProgressFillValue = u16ProgressFillValue;
}

/************************************************************************
*FUNCTION			: SetDefaultProgressColor
*DESCRIPTION		: To Set Default Progress Color.
*PARAMETER			: tU32 (I)
*PARAMETER				Color
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::SetDefaultProgressColor(tU32 u32Color)
{
	m_u32DefaultProgressColor = u32Color;
}

tVoid line::SetProgressBarTextHeight(tU16 u16Height)
{
	m_u16FontHeight = u16Height;
}

/************************************************************************
*FUNCTION			: SetCompletePercentColor
*DESCRIPTION		: To Set Complete Percent Color
*PARAMETER			: tU32 (I)
*PARAMETER				Color
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::SetCompletePercentColor(tU32 u32Color)
{
	m_u32CompletePercentColor = u32Color;
}

/************************************************************************
*FUNCTION			: ShowOutLine
*DESCRIPTION		: To Draw Outline on Screen
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::ShowOutLine()
{
	LineInfo stLineInfo;

	stLineInfo.u16XPos 				= m_u16Xpos;
	stLineInfo.u16YPos 				= m_u16Ypos;
	stLineInfo.u16Width				= m_u16LineWidth;
	stLineInfo.stcolor.u8Red 		= (m_u32FGColor >> 16) & 0xFF;
	stLineInfo.stcolor.u8Green 		= (m_u32FGColor >> 8) & 0xFF;
	stLineInfo.stcolor.u8Blue  		= (m_u32FGColor >> 0) & 0xFF;

	graphicsinterface::ShowOutLine(stLineInfo);
}

/************************************************************************
*FUNCTION			: ShowProgressBar
*DESCRIPTION		: To Draw the Progress Bar
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::ShowProgressBar()
{
	ProgressBarInfo stProgressInfo;

	stProgressInfo.u16XPos 							= m_u16Xpos;
	stProgressInfo.u16YPos 							= m_u16Ypos;
	stProgressInfo.u16Width							= m_u16Width;
	stProgressInfo.u16Height						= m_u16Height;
	stProgressInfo.u16FontHeight					= m_u16FontHeight;
	stProgressInfo.u16PercentageFillValue			= m_u16ProgressFillValue;
	stProgressInfo.u16PercentageCompleted   		= m_16ProgressValue;
	stProgressInfo.u16BorderWidth					= m_u16LineWidth;
	stProgressInfo.stBorderColor.u8Red 				= (m_u32BorderColor >> 16) & 0xFF;
	stProgressInfo.stBorderColor.u8Green 			= (m_u32BorderColor >> 8) & 0xFF;
	stProgressInfo.stBorderColor.u8Blue  			= (m_u32BorderColor >> 0) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Red 		= (m_u32DefaultProgressColor >> 16) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Green 		= (m_u32DefaultProgressColor >> 8) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Blue  		= (m_u32DefaultProgressColor >> 0) & 0xFF;

	graphicsinterface::ShowProgressBar(stProgressInfo);

}

/************************************************************************
*FUNCTION			: ShowProgressBar
*DESCRIPTION		: To Draw the Progress Bar 1
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid line::ShowProgressBar1()
{
   ProgressBarInfo stProgressInfo = {};

	stProgressInfo.u16XPos 									= m_u16Xpos;
	stProgressInfo.u16YPos 									= m_u16Ypos;
	stProgressInfo.u16Width									= m_u16Width;
	stProgressInfo.u16Height								= m_u16Height;
	stProgressInfo.u16FontHeight							= m_u16FontHeight;
	stProgressInfo.u16PercentageCompleted   				= m_16ProgressValue;
	stProgressInfo.u16BorderWidth							= m_u16LineWidth;
	stProgressInfo.u16PercentageFillValue					= m_u16ProgressFillValue; //Coverity fix for 21783
	stProgressInfo.stBorderColor.u8Red 						= (m_u32BorderColor >> 16) & 0xFF;
	stProgressInfo.stBorderColor.u8Green 					= (m_u32BorderColor >> 8) & 0xFF;
	stProgressInfo.stBorderColor.u8Blue  					= (m_u32BorderColor >> 0) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Red 				= (m_u32DefaultProgressColor >> 16) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Green 				= (m_u32DefaultProgressColor >> 8) & 0xFF;
	stProgressInfo.stDefaultFillColor.u8Blue  				= (m_u32DefaultProgressColor >> 0) & 0xFF;
	stProgressInfo.stCompletePercentageColor.u8Red 			= (m_u32CompletePercentColor >> 16) & 0xFF;
	stProgressInfo.stCompletePercentageColor.u8Green 		= (m_u32CompletePercentColor >> 8) & 0xFF;
	stProgressInfo.stCompletePercentageColor.u8Blue  		= (m_u32CompletePercentColor >> 0) & 0xFF;
   stProgressInfo.u16PercentageFillValue = m_u16ProgressFillValue;

	graphicsinterface::ShowProgressBar1(stProgressInfo);
}

