
/************************************************************************
*FILE					: swuhmi_label.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Label Class which derived from Widget Base class.
*DESCRIPTION			: Which Implements Text Drawing.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#include "swuhmi_label.h"
#include "swuhmi_graphicsinterface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_LABEL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::label::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_label.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION			: label
*DESCRIPTION		: Constructor of Label
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
label::label()
{
	m_strTextToDisplay.clear();
	m_eLabelAlign			= E_LABEL_INVALID_ALIGNMENT;
	m_bTranslationStatus	= false;
	m_u16FontHeight			= 0;
}

/************************************************************************
*FUNCTION			: label
*DESCRIPTION		: Destructor of Label
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
label::~label()
{

}

/************************************************************************
*FUNCTION			: InitializeLabel
*DESCRIPTION		: To Initialize the Label
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid label::InitializeLabel()
{
	ETG_TRACE_USR2(("InitializeLabel"));
}

/************************************************************************
*FUNCTION			: DeInitializeLabel
*DESCRIPTION		: To De-Initialize the Label
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid label::DeInitializeLabel()
{

}

/************************************************************************
*FUNCTION			: DrawText
*DESCRIPTION		: To Draw Text on First in Particular XPos and YPos.
*PARAMETER			: string (I)
*PARAMETER				Text to be Draw
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid label::DrawText(string strText)
{
	LabelInfo stLabelInfo;
	stLabelInfo.u16XPos 		= m_u16Xpos;
	stLabelInfo.u16YPos 		= m_u16Ypos;
	stLabelInfo.u16Height  		= m_u16FontHeight;
	stLabelInfo.strText 		= strText;
	stLabelInfo.eAlign  		= m_eLabelAlign;
	stLabelInfo.stcolor.u8Red 	= (m_u32FGColor >> 16) & 0xFF;
	stLabelInfo.stcolor.u8Green = (m_u32FGColor >> 8) & 0xFF;
	stLabelInfo.stcolor.u8Blue  = (m_u32FGColor >> 0) & 0xFF;

	if(m_bTranslationStatus)
		graphicsinterface::DrawTranslatedText(stLabelInfo);
	else
		graphicsinterface::DrawText(stLabelInfo);
}

/************************************************************************
*FUNCTION			: UpdateText
*DESCRIPTION		: To Update the Text on Same Location.
*PARAMETER			: string (I)
*PARAMETER				Text to be Update
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid label::UpdateText(string strText)
{
	LabelInfo stLabelInfo;
	stLabelInfo.u16XPos 		= m_u16Xpos;
	stLabelInfo.u16YPos 		= m_u16Ypos;
	stLabelInfo.u16Height  		= m_u16FontHeight;
	stLabelInfo.strPrevText		= m_strPrevText;
	stLabelInfo.strText 		= strText;
	stLabelInfo.eAlign  		= m_eLabelAlign;
	stLabelInfo.stcolor.u8Red 	= (m_u32FGColor >> 16) & 0xFF;
	stLabelInfo.stcolor.u8Green = (m_u32FGColor >> 8) & 0xFF;
	stLabelInfo.stcolor.u8Blue  = (m_u32FGColor >> 0) & 0xFF;

	graphicsinterface::UpdateText(stLabelInfo);
}

