
/************************************************************************
*FILE					: swuhmi_image.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Image Class which derived from Widget Base class.
*DESCRIPTION			: Which handles the Image in App for drawing.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#include "swuhmi_image.h"
#include "swuhmi_graphicsinterface.h"

image::image()
{
	// TODO Auto-generated constructor stub
	m_strPrevImagePath.clear();

}

image::~image() {
	// TODO Auto-generated destructor stub
}

/************************************************************************
*FUNCTION			: SetPreviousImagePath
*DESCRIPTION		: To set the previous Image Path, It is used for clearing in Graphics
*PARAMETER			: string (I)
*PARAMETER				Image Name with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid image::SetPreviousImagePath(string strPrevImagePath)
{
	m_strPrevImagePath = strPrevImagePath;
}

/************************************************************************
*FUNCTION			: UpdateImage
*DESCRIPTION		: To Redraw the Image on same position.
*PARAMETER			: string (I)
*PARAMETER				Image Name with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid image::UpdateImage(string strPath)
{
	ImageInfo stImageInfo;

	stImageInfo.u16XPos 		= m_u16Xpos;
	stImageInfo.u16YPos 		= m_u16Ypos;
	stImageInfo.PrevImagePath	= m_strPrevImagePath;
	stImageInfo.ImagePath 		= strPath;

	graphicsinterface::UpdateImage(stImageInfo);


}

