
/************************************************************************
*FILE					: swuhmi_component.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: ASF Class For fcswupdatesrv. Main Class For SWUHMI
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
#ifndef SWUHMI_COMPONENT_H_
#define SWUHMI_COMPONENT_H_

#pragma once
#include <iostream>
#include <algorithm>

#include "swuhmi_component_inc.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "fcswupdatesrv/FcSwUpdateSrvProxy.h" 


#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "util/swu_msg.hpp"
#include "util/swu_asfUtil.hpp"

#include "asf/core/ApplicationIF.h"

#include "swuhmi_configurator.h"
#include "swuhmi_systemsettings.h"

using namespace ::asf::core;

namespace swuhmi {

#define AUTO_PROPERTY(PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL) \
   AUTO_PROPERTY_BASE(swuhmicomponent, swuhmicomponent, PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL)

#define AUTO_PROPERTY_CMS(PROXY_GETTER, PROPERTY,LINE) AUTO_PROPERTY(PROXY_GETTER, PROPERTY, LINE, Register, Deregister, DeregisterAll)

#define AUTO_PROPERTY_FCSWUPDATE(PROPERTY) AUTO_PROPERTY_CMS(getFcSwUpdSrvProxy, PROPERTY, __LINE__)

#define DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_SPM, CFC_SPM_FIProxy, SystemStateStatus) \
   DISPATCHABLE_MSG_DECL_PROXY(FcSwUHMIRoot, FCSWUPD_NS_SPM, CFC_SPM_FIProxy, SystemStateStatus );

/*lint -save -e19 */
DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateStateUpdate);
DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateProgressUpdate);
DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateBgImageInfoUpdate);
DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateErrorsUpdate);
DISPATCHABLE_MSG_DECL_PROXY_SWUHMI(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateResultUpdate);
/*lint -restore */ 

class swuhmicomponent:
	public swu::Singleton<swuhmicomponent>,
	public BaseComponent,
	public swu::Member<FcSwUHMIRoot>,

	// notification of srv-availabilty of other services
	public ServiceAvailableIF,

	//Properties
	private FCSWUPD_NS_FCSWUPD::UpdateStateCallbackIF,
	private FCSWUPD_NS_FCSWUPD::UpdateProgressCallbackIF,
	private FCSWUPD_NS_FCSWUPD::UpdateBgImageInfoCallbackIF,
	private FCSWUPD_NS_FCSWUPD::UpdateErrorsCallbackIF,
	private FCSWUPD_NS_FCSWUPD::UpdateResultCallbackIF
{
	friend class swu::Singleton<swuhmicomponent>;
	template<class COMP, class PROXY>
	friend class swu::NotifyAvail;
public:

	swuhmicomponent();
	void vInit();
	virtual ~swuhmicomponent();

	virtual const char *getName() {
		return "swuhmicomponent";
	 }
	 virtual void traceState();


	// ServiceAvailableIF
	virtual void onAvailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange);

	virtual void onUnavailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange);

	//Interface From FCSWUpdate
	AUTO_DISPATCH_RES(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateStateUpdate);
	AUTO_DISPATCH_ERROR(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateStateError);

	AUTO_DISPATCH_RES(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateProgressUpdate);
	AUTO_DISPATCH_ERROR(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateProgressError);

	AUTO_DISPATCH_RES(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateBgImageInfoUpdate);
	AUTO_DISPATCH_ERROR(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateBgImageInfoError);

	AUTO_DISPATCH_RES(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateErrorsUpdate);
	AUTO_DISPATCH_ERROR(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateErrorsError);

	AUTO_DISPATCH_RES(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateResultUpdate);
	AUTO_DISPATCH_ERROR(FCSWUPD_NS_FCSWUPD, FcSwUpdateSrvProxy, UpdateResultError);


	void bSendLoobBackMsg(swu::MsgCompBase<FcSwUHMIRoot> *pMsg);

	::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvProxy >getFcSwUpdSrvProxy() {
		return m_FcSwUpdateProxy;
	}

	void simFcSwuUpdateStateResult();
	void simFcSwuScreenShot(char const* pFileName);

public:
	swu::ProxyList _proxyList;
	static list<swu::AutoProperty *> _autoPropertyList;
 
private:

	AUTO_PROPERTY_FCSWUPDATE(UpdateState);
	AUTO_PROPERTY_FCSWUPDATE(UpdateProgress);
	AUTO_PROPERTY_FCSWUPDATE(UpdateBgImageInfo);
	AUTO_PROPERTY_FCSWUPDATE(UpdateErrors);
	AUTO_PROPERTY_FCSWUPDATE(UpdateResult);

	boost::shared_ptr< FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvProxy > m_FcSwUpdateProxy;
	swu::ProxyAccess<swuhmicomponent, FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvProxy> _FcSwUpdateProxy;

	swu::MemberList<FcSwUHMIRoot> m_memberList;

	DECLARE_CLASS_LOGGER ();

};

}

#endif
