
/************************************************************************
*FILE					: swuhmi_component.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: ASF Class For fcswupdatesrv. Main Class For SWUHMI
*DESCRIPTION			: SWUHMI will start from the constructor of this class
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

//#include <systemd/sd-daemon.h>

#ifdef VARIANT_S_FTR_ENABLE_SWU_DBUS
#include "fcswupdatesrv/FcSwUpdateSrvDBus.h"
#endif

#include "swuhmi_component.h"
#include "../widgets/swuhmi_graphicsinterface.h"

#define ETG_I_FILE_PREFIX swuhmi::swuhmicomponent::instance()->

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "SWUHMI_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_SWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_component.cpp.trc.h"
#endif


namespace swuhmi {

bool FcSwUHMIRoot::bSendLoobBackMsg(swu::MsgCompBase<FcSwUHMIRoot> *msg) {
	swuhmicomponent::instance()->bSendLoobBackMsg(msg);
	return true;
}

list< swu::AutoProperty * > swuhmicomponent::_autoPropertyList;
DEFINE_CLASS_LOGGER_AND_LEVEL("swuhmi", swuhmicomponent, Info);

/************************************************************************
*FUNCTION			: swuhmicomponent
*DESCRIPTION		: constructor of swuhmicomponent
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
swuhmicomponent::swuhmicomponent()
{
	setInstance(this);

	vInitPlatformEtg();
	// register exception-handler to get callstacks via ttfis
	swu::registerSignalHandler();

	ETG_I_REGISTER_FILE();
	ETG_I_REGISTER_CHN(0);

	ETG_TRACE_USR4(("swuhmicomponent::swuhmicomponent() CTOR start"));

	m_FcSwUpdateProxy = FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvProxy::createProxy("fcSwUpdatePort",*this);

	ETG_TRACE_USR4(("swuhmicomponent::swuhmicomponent() CTOR end"));

	poGetProjectSpecific()->Initializeconfigurator();
}

/************************************************************************
*FUNCTION			: vInit
*DESCRIPTION		: Init of Member List
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid swuhmicomponent::vInit()
{
	_FcSwUpdateProxy.setProxy(m_FcSwUpdateProxy, "fcSwUpdatePort");
	m_memberList.addMember(poGetProjectSpecific());
	m_memberList.vInit();

}

/************************************************************************
*FUNCTION			: swuhmicomponent
*DESCRIPTION		: Destructor of swuhmicomponent
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
swuhmicomponent::~swuhmicomponent(){
	ETG_I_UNREGISTER_FILE();
}

/************************************************************************
*FUNCTION			: traceState
*DESCRIPTION		: Trace State the swuhmicomponent
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
void swuhmicomponent::traceState()
{
	ETG_TRACE_USR4(("  Proxys availability:"));
	map <std::string, swu::ProxyAccessBase * > const &proxyList=_proxyList.getList();
	for(map <std::string, swu::ProxyAccessBase * >::const_iterator iter =proxyList.begin();
			iter !=proxyList.end();++iter)
	{
	      string const &name=iter->first;
	      ETG_TRACE_USR4(("    %20s:        %u", name.c_str(), iter->second->getProxyBase()->isAvailable()));
	}
	m_memberList.traceState(getName());
}

/************************************************************************
*FUNCTION			: onAvailable
*DESCRIPTION		: ASF OnAvailable call
*PARAMETER			: BOOST (I)
*PARAMETER				Proxy
*PARAMETER			  enum (I)
*PARAMETER			  	State Change
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
void swuhmicomponent::onAvailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange)
{
	vInit();
	ETG_TRACE_USR4(("swuhmicomponent::onAvailable  START"));
	(void)stateChange;
	 ETG_TRACE_USR4(("swuhmicomponent::onAvailable  START State=%i proxy=%s", proxy->getServiceState(), proxy->getPortName().c_str()));

	 _proxyList.onAvail(proxy, true);

	 ETG_TRACE_USR4(("AutoProperty Size:%d", _autoPropertyList.size()));

	 for (list< swu::AutoProperty * >::iterator iter = _autoPropertyList.begin();
			 iter != _autoPropertyList.end(); ++iter)
	 {
		 if ((*iter)->getProxy() == proxy)
		 {
			 ETG_TRACE_USR4(("swuhmicomponent::onAvailable: found proxy %s  START", (*iter)->getName()));
	         (*iter)->vOnSrvAvail();
		 }
	 }

	 ETG_TRACE_USR4(("swuhmicomponent::onAvailable  END"));
}

/************************************************************************
*FUNCTION			: onUnavailable
*DESCRIPTION		: ASF OUnavailable call
*PARAMETER			: BOOST (I)
*PARAMETER				Proxy
*PARAMETER			  enum (I)
*PARAMETER			  	State Change
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
void swuhmicomponent::onUnavailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange)
{
	(void)stateChange;
	 ETG_TRACE_USR4(("swuhmicomponent::onUnavailable  START"));

	 _proxyList.onAvail(proxy, false);
	 for (list< swu::AutoProperty * >::iterator iter = _autoPropertyList.begin();
				 iter != _autoPropertyList.end(); ++iter)
	 {
		 if ((*iter)->getProxy() == proxy)
		 {
			 ETG_TRACE_USR4(("swuhmicomponent::onUnavailable: found proxy %s  START", (*iter)->getName()));
			 (*iter)->vOnSrvUnavail();
		 }
	 }

	 ETG_TRACE_USR4(("swuhmicomponent::onUnavailable  END"));
}

/************************************************************************
*FUNCTION			: bSendLoobBackMsg
*DESCRIPTION		: To Send the Internal Posting to ASF Message.
*PARAMETER			: MsgCompBase (I)
*PARAMETER				Message to be Posted.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
void swuhmicomponent::bSendLoobBackMsg(swu::MsgCompBase<FcSwUHMIRoot> *pMsg)
{
	(void*) pMsg;
}



ETG_I_CMD_DEFINE((simFcSwuUpdateStateResult, "simFcSwuUpdateStateResult"))
void swuhmicomponent::simFcSwuUpdateStateResult()
{
	ETG_TRACE_USR4(("simFcSwuUpdateStateResult"));
	   const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD::UpdateStateUpdate > payload(
	         new FCSWUPD_NS_FCSWUPD::UpdateStateUpdate());
	   onUpdateStateUpdate(getFcSwUpdSrvProxy(), payload);

}

ETG_I_CMD_DEFINE((simFcSwuScreenShot, "simFcSwuScreenShot %s", ETG_I_STRING))
void swuhmicomponent::simFcSwuScreenShot(char const* pFileName)
{
	string strFileName;
	strFileName.assign(pFileName);
	ETG_TRACE_USR4(("simFcSwuScreenShot"));
	graphicsinterface::TakeScreenShot(strFileName);
}




}



