/************************************************************************
*FILE					: swuhmi_includes.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: This file is contains all #define, enums and constant.
*DESCRIPTION			: It is used by all classes which is present in the App.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_HMIINCLUDES_H_
#define SWUHMI_HMIINCLUDES_H_


#include <iostream>
#include "../util/swu_types.h"
#include "../base/imp/swupd_trace.h"
#include "sstream"
#include <iostream>
#include <fstream>
#include <cstdio>

#define TRANSLATION_XML_FILE_PATH					"resources/Text.xml"
#define HMISETTINGS_XML_FILE						"/var/opt/bosch/persistent/swupdate/hmi/hmisettings.xml"

#define SWUHMI_SWUPDCORE_PERSISTENT_ROOT			"/var/opt/bosch/persistent/swupdate/hmi/"
#define SWUHMI_INITRAMFS_ROOT						"/opt/bosch/base/bin/resources/"

using namespace std;



typedef enum
{
	E_HMI_INVALID_STATE  = 0,
	E_HMI_WAITING_FOR_MEDIA_STATE,
	E_HMI_SW_UPDATE_STATE,
	E_HMI_MEDIUM_REMOVED_STATE,
	E_HMI_UPDATE_FAILURE_STATE,
	E_HMI_UPDATE_SIGNATURE_FAILURE_STATE,
	E_HMI_UPDATE_UNKNOWN_FAILURE_STATE,
	E_HMI_UPDATE_SUCCESS_STATE
}E_HMI_STATE;


typedef enum
{
	E_LABEL_INVALID_ALIGNMENT = 0,
	E_LABEL_LEFT_ALIGNMENT,
	E_LABEL_RIGHT_ALIGNMENT,
	E_LABEL_HORIZONTAL_CENTER_ALIGNMENT,
	E_LABEL_VERTICAL_CENTER_ALIGNMENT
}E_LABEL_ALIGNMENT;



typedef enum
{
	E_INVALID_MODULE = 0,
	E_IMX_MODULE,
	E_V850_MODULE,
	E_ADR_MODULE,
	E_TESEO_MODULE,
	E_SXM_MODULE
}E_MODULE;

typedef enum {
	E_USB_SOURCE,
	E_SD_SOURCE,
	E_OTA_SOURCE,
	E_OTHER_SOURCE
}E_SOURCE_TYPE;


struct color
{
    tU8 u8Red;
    tU8 u8Green;
    tU8 u8Blue;
};

struct LineInfo
{
	tU16		u16XPos;
	tU16		u16YPos;
	tU16		u16Width;
	color		stcolor;
};

struct ProgressBarInfo
{
	tU16 		u16XPos;
	tU16		u16YPos;
	tU16		u16Width;
	tU16		u16Height;
	tU16		u16FontHeight;
	tU16		u16BorderWidth;
	color		stBorderColor;
	color		stDefaultFillColor;
	color 		stCompletePercentageColor;
	tU16		u16PercentageFillValue;
	tU16		u16PercentageCompleted;
};

struct LabelInfo
{
	tU16 				u16XPos;
	tU16 				u16YPos;
	tU16				u16Height;
	string 				strPrevText;
	string 				strText;
	E_LABEL_ALIGNMENT	eAlign;
	color				stcolor;
};

struct ImageInfo
{
	tU16			u16XPos;
	tU16			u16YPos;
	string 			PrevImagePath;
	string			ImagePath;
};

struct ProgressInfo
{
	tU16			u16XPos;
	tU16			u16YPos;
	string			strText;
	color			stcolor;
};


#endif
