#ifndef SWUHMI_CONFIG_HPP
#define SWUHMI_CONFIG_HPP
#include <set>
#include <string>
#include "util/swu_configBase.hpp"
#include "util/swu_singleton.hpp"

typedef swu::ConfigItem<std::string> strConfigItem;
typedef swu::ConfigItem<tU32> u32ConfigItem;
typedef swu::ConfigItem<std::vector<tU8> > vectorConfigItem;


namespace swuhmi {


#define GET_CFG(a, b) Config::instance()->cfg_#a.get(b))



class Config:
      public swu::ConfigBase,
      public swu::Singleton<Config> {
public:
      friend class swu::Singleton<Config>;

      virtual ~Config();

      virtual char const *getName() {
         return "Config";
      }

      virtual void traceState();
	  
	  static std::string const &getPersistentDataStoreFileName();
	  static std::string const &getNonPersistentDataStoreFileName();
	  static bool getUsePersistentPart();

      /*
        Font Info
       */
      swu::ConfigItem<std::string>   cfg_FontPath;
      swu::ConfigItem<tU32>          cfg_FontHeight;
      swu::ConfigItem<tU32>          cfg_FontAligment;
	  
	  
	  /*
	  Header Text Info
       */
      swu::ConfigItem<tU32>          cfg_HeaderTextXPos;
      swu::ConfigItem<tU32>          cfg_HeaderTextYPos;
      swu::ConfigItem<tU32>			 cfg_HeaderLargeFontHeight;
      swu::ConfigItem<tU32>          cfg_HeaderTextWhiteColor;

      /*
        Background Image
      */      
      swu::ConfigItem<tU32>          cfg_BackGndImageXPos;
      swu::ConfigItem<tU32>          cfg_BackGndImageYPos; 
      
	  /*
	  		Border Info
      */
      swu::ConfigItem<tU32>          cfg_BorderXPos;
      swu::ConfigItem<tU32>          cfg_BorderYPos;
      swu::ConfigItem<tU32>          cfg_BorderWidth;
      swu::ConfigItem<tU32>          cfg_BorderWhiteColor;
	  
	   /*
       Status Label
		 */
      swu::ConfigItem<tU32>          cfg_InfoLabelXPos;
      swu::ConfigItem<tU32>          cfg_InfoLabelYPosFromBottom;
      swu::ConfigItem<tU32>          cfg_DeviceIdLabelYPosFromBottom;
      swu::ConfigItem<tU32>			 cfg_StatusMediumFontHeight;
      swu::ConfigItem<tU32>          cfg_StatusWhiteColor;
	  

	  
	  /* Aivi Recovery Wnd 
	  */
      swu::ConfigItem<tU32>          cfg_RemaningTimeTextFromRight;
      swu::ConfigItem<tU32>          cfg_RemaningTimeTextFromBottom;
      swu::ConfigItem<tU32>          cfg_RemaingTimeTextMediumFontHeight;
      swu::ConfigItem<tU32>          cfg_RemaingTimeTextWhiteColor;
	  
      swu::ConfigItem<tU32>          cfg_RemaningTimeFromRight;
      swu::ConfigItem<tU32>          cfg_RemaningTimeFromBottom;
      swu::ConfigItem<tU32>          cfg_RemaingTimeMediumFontHeight;
      swu::ConfigItem<tU32>          cfg_RemaingTimeWhiteColor;
	  
      swu::ConfigItem<tU32>          cfg_InfoTextXPosFromLeft;
      swu::ConfigItem<tU32>          cfg_InfoTextYPosFromBottom;
      swu::ConfigItem<tU32>          cfg_InfoLabelMediumFontHeight;
      swu::ConfigItem<tU32>          cfg_InfoLabelWhiteColor;
	  
      swu::ConfigItem<tU32>          cfg_ProgressbarXPosFromLeft;
      swu::ConfigItem<tU32>          cfg_ProgressbarYPosFromBottom;
      swu::ConfigItem<tU32>          cfg_ProgressbarWidth;
      swu::ConfigItem<tU32>          cfg_ProgressbarHeight;
	  
	  
      /*
        BackGround and Progressbar Image Info
       */
      swu::ConfigItem<std::string>   cfg_DefaultBasePath;
      swu::ConfigItem<std::string>   cfg_BackGndImagePath;
      swu::ConfigItem<std::string>   cfg_ProgressbarBackGndImage;
      swu::ConfigItem<std::string>   cfg_ProgressbarForeGndImage;
      swu::ConfigItem<std::string>   cfg_ProgressbarMeasurementImage;
      swu::ConfigItem<std::string>   cfg_ProgressbarProgressPointerImage;

      /*
       colors
       */
      swu::ConfigItem<tU32>          cfg_lightGrayColor;
       
   

protected:
      Config();
   
};

}
#endif
