
/************************************************************************
*FILE					: swuhmi_cairoadapter.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: CAIRO GRAPHICS Adapter.
*DESCRIPTION			: It is Graphics Interface where we can achieve all the Drawing Funtionality.
*REFERENCE				: http://cairographics.org/tutorial/
 	 	 	 	 	 	: http://cairographics.org/operators/
 	 	 	 	 	 	: http://cairographics.org/FAQ/
 	 	 	 	 	 	: http://zetcode.com/gfx/cairo/
 	 	 	 	 	 	: http://www.ie.u-ryukyu.ac.jp/~e085739/c.cairo.html
 	 	 	 	 	 	: http://cairographics.org/samples/
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
13-07-2016	| 0.2		| AGL5KOR			| CMG3G-10993 - Generic Way of Handling the Long Text in Cairo Adapter 
28-02-2017	| 0.3		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter
************************************************************************/

#ifndef SWUHMI_CAIROADAPTER_H_
#define SWUHMI_CAIROADAPTER_H_

#define CAIRO_RECTANGLE_ADD_SPACE		10
#define CAIRO_MAX_YPOS					50
#define CAIRO_OUTLINE_XPOS				 8
#define CAIRO_OUTLINE_YPOS				 8
#define CAIRO_PROGRESSBAR				 2
#define CAIRO_PROGRESSVALUE_XPOS		10
#define CAIRO_PROGRESSVALUE_YPOS		10

#define TOTAL_PROGRESS_BAR				25
#define FIRST_PROGRESS_BAR				 1
#define LAST_PROGRESS_BAR				25

#define EXTRA_FONT_WIDTH				5
#define EXTRA_FONT_HEIGHT				3
#define EXTRA_LINE_SPACE_BETWEEN_LINES	10
#define WIDTH_ADJUSTMENT_VAL			100


#include "../config/swuhmi_includes.h"
#include "swuhmi_drmrender.h"

#include <cairo.h>
#include <cairo-ft.h>

class cairoadapter {
public:
	cairoadapter();
	virtual ~cairoadapter();

	tBool InitializeCairoAdapter();
	tVoid ReSurface();
	tBool CreateSurface();
	tVoid ClearSurface();

	tVoid SetBackGndImage(string strPath,float xPos=0.0,float yPos=0.0);
	tBool CreateFont(string strPath, bool useSynthFlags=true, int synthFlags= CAIRO_FT_SYNTHESIZE_BOLD);
	tBool CreateChineseFont(string strPath, bool useSynthFlags=true, int synthFlags= CAIRO_FT_SYNTHESIZE_BOLD);

	tVoid UpdateImage(ImageInfo stImageInfo);

	tVoid DrawText(LabelInfo stLabelInfo);
	tVoid UpdateText(LabelInfo stLabelInfo);

	tVoid DrawOutLine(LineInfo stLineInfo);
	tVoid DrawTranslatedText(LabelInfo stLabelInfo);

	tVoid DrawProgressBar(ProgressBarInfo stProgressInfo);
	tVoid DrawProgressBar1(ProgressBarInfo stProgressInfo);

	tVoid FlipThePage();

	tVoid TakeScreenShot(string strFileName);

	tU32 GetWindowWidth() 	{ return m_u32Width; }
	tU32 GetWindowHeight() 	{ return m_u32Height; }

	tVoid SetDelimiter(string strDelimiter);
	
private:
	drmrender				m_DRMRenderInst;
	cairo_surface_t*		m_pCairoSurface;
//	cairo_t*				m_pCairo;


	cairo_font_face_t*		m_pfont;
	cairo_font_face_t*		m_pChinesefont;
	cairo_user_data_key_t 	m_ft_cairo_user_data_key;
	FT_Library 				m_FreeTypeLib;

	tU8*					m_U8FrameBuffer;
	tU32					m_u32Stride;

private:
	tVoid InitFreeTypeLib();
	tVoid DrawTestImage();
	tVoid DestroySurface();
	tVoid DrawTextWithoutDelimiter(LabelInfo stLabelInfo, bool IsTranslatedText = false);
	tVoid DrawTextWithDelimiter(LabelInfo stLabelInfo, bool IsTranslatedText = false);
	tVoid DrawNormalText(LabelInfo stLabelInfo);
	tVoid DrawAbNormalText(LabelInfo stLabelInfo);
	
protected:
	cairo_t*				m_pCairo;
	tU32					m_u32Width;
	tU32					m_u32Height;
	string                  m_strDelimiter;
	tDouble 				m_dLineOffset;
};

#endif /* CAIROADAPTER_H_ */
